/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.util;

import android.graphics.drawable.Drawable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.request.Request;
import com.bumptech.glide.request.target.SizeReadyCallback;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.bumptech.glide.util.Util;
import java.io.File;

public abstract class ImageDownloadTarget
implements Target<File> {
    private Request request;
    private final int width;
    private final int height;

    protected ImageDownloadTarget() {
        this(Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    private ImageDownloadTarget(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void onResourceReady(@NonNull File resource, Transition<? super File> transition) {
    }

    public void onLoadCleared(Drawable placeholder) {
    }

    public void onLoadStarted(Drawable placeholder) {
    }

    public void onLoadFailed(Drawable errorDrawable) {
    }

    public final void getSize(@NonNull SizeReadyCallback cb) {
        if (!Util.isValidDimensions((int)this.width, (int)this.height)) {
            throw new IllegalArgumentException("Width and height must both be > 0 or Target#SIZE_ORIGINAL, but given width: " + this.width + " and height: " + this.height + ", either provide dimensions in the constructor or call override()");
        }
        cb.onSizeReady(this.width, this.height);
    }

    public void removeCallback(@NonNull SizeReadyCallback cb) {
    }

    public void setRequest(@Nullable Request request) {
        this.request = request;
    }

    @Nullable
    public Request getRequest() {
        return this.request;
    }

    public void onStart() {
    }

    public void onStop() {
    }

    public void onDestroy() {
    }
}

