/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.impl;

import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import com.lxj.xpopup.R;
import com.lxj.xpopup.XPopup;
import com.lxj.xpopup.animator.PopupAnimator;
import com.lxj.xpopup.animator.TranslateAnimator;
import com.lxj.xpopup.core.BasePopupView;
import com.lxj.xpopup.enums.PopupAnimation;
import com.lxj.xpopup.util.XPopupUtils;

public class FullScreenPopupView
extends BasePopupView {
    public ArgbEvaluator argbEvaluator = new ArgbEvaluator();
    protected View contentView;
    protected FrameLayout fullPopupContainer;
    Paint paint = new Paint();
    Rect shadowRect;
    int currColor = 0;

    public FullScreenPopupView(@NonNull Context context) {
        super(context);
        this.fullPopupContainer = (FrameLayout)this.findViewById(R.id.fullPopupContainer);
    }

    @Override
    protected int getPopupLayoutId() {
        return R.layout._xpopup_fullscreen_popup_view;
    }

    protected void addInnerContent() {
        this.contentView = LayoutInflater.from((Context)this.getContext()).inflate(this.getImplLayoutId(), (ViewGroup)this.fullPopupContainer, false);
        this.fullPopupContainer.addView(this.contentView);
    }

    @Override
    protected void initPopupContent() {
        super.initPopupContent();
        if (this.fullPopupContainer.getChildCount() == 0) {
            this.addInnerContent();
        }
        this.getPopupContentView().setTranslationX((float)this.popupInfo.offsetX);
        this.getPopupContentView().setTranslationY((float)this.popupInfo.offsetY);
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.popupInfo != null && this.popupInfo.hasStatusBarShadow.booleanValue()) {
            this.paint.setColor(this.currColor);
            this.shadowRect = new Rect(0, 0, this.getMeasuredWidth(), XPopupUtils.getStatusBarHeight());
            canvas.drawRect(this.shadowRect, this.paint);
        }
    }

    @Override
    protected void doShowAnimation() {
        super.doShowAnimation();
        this.doStatusBarColorTransform(true);
    }

    @Override
    protected void doDismissAnimation() {
        super.doDismissAnimation();
        this.doStatusBarColorTransform(false);
    }

    public void doStatusBarColorTransform(boolean isShow) {
        if (this.popupInfo != null && this.popupInfo.hasStatusBarShadow.booleanValue()) {
            ValueAnimator animator = ValueAnimator.ofObject((TypeEvaluator)this.argbEvaluator, (Object[])new Object[]{isShow ? 0 : XPopup.statusBarShadowColor, isShow ? XPopup.statusBarShadowColor : 0});
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    FullScreenPopupView.this.currColor = (Integer)animation.getAnimatedValue();
                    FullScreenPopupView.this.postInvalidate();
                }
            });
            animator.setDuration((long)XPopup.getAnimationDuration()).start();
        }
    }

    @Override
    protected PopupAnimator getPopupAnimator() {
        return new TranslateAnimator(this.getPopupContentView(), PopupAnimation.TranslateFromBottom);
    }

    @Override
    protected void onDetachedFromWindow() {
        if (this.popupInfo != null) {
            this.getPopupContentView().setTranslationX((float)this.popupInfo.offsetX);
        }
        if (this.popupInfo != null) {
            this.getPopupContentView().setTranslationY((float)this.popupInfo.offsetY);
        }
        super.onDetachedFromWindow();
    }
}

