/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.core;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.EditText;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import com.lxj.xpopup.XPopup;
import com.lxj.xpopup.animator.BlurAnimator;
import com.lxj.xpopup.animator.EmptyAnimator;
import com.lxj.xpopup.animator.PopupAnimator;
import com.lxj.xpopup.animator.ScaleAlphaAnimator;
import com.lxj.xpopup.animator.ScrollScaleAnimator;
import com.lxj.xpopup.animator.ShadowBgAnimator;
import com.lxj.xpopup.animator.TranslateAlphaAnimator;
import com.lxj.xpopup.animator.TranslateAnimator;
import com.lxj.xpopup.core.AttachPopupView;
import com.lxj.xpopup.core.FullScreenDialog;
import com.lxj.xpopup.core.PopupInfo;
import com.lxj.xpopup.enums.PopupAnimation;
import com.lxj.xpopup.enums.PopupStatus;
import com.lxj.xpopup.impl.FullScreenPopupView;
import com.lxj.xpopup.impl.PartShadowPopupView;
import com.lxj.xpopup.util.KeyboardUtils;
import com.lxj.xpopup.util.XPopupUtils;
import java.util.ArrayList;

public abstract class BasePopupView
extends FrameLayout
implements LifecycleObserver {
    public PopupInfo popupInfo;
    protected PopupAnimator popupContentAnimator;
    protected ShadowBgAnimator shadowBgAnimator;
    protected BlurAnimator blurAnimator;
    private int touchSlop;
    public PopupStatus popupStatus = PopupStatus.Dismiss;
    protected boolean isCreated = false;
    private Handler handler = new Handler(Looper.getMainLooper());
    private Runnable initTask = new Runnable(){

        @Override
        public void run() {
            if (BasePopupView.this.dialog == null || BasePopupView.this.getHostWindow() == null) {
                return;
            }
            if (BasePopupView.this.popupInfo.xPopupCallback != null) {
                BasePopupView.this.popupInfo.xPopupCallback.beforeShow(BasePopupView.this);
            }
            BasePopupView.this.focusAndProcessBackPress();
            if (!(BasePopupView.this instanceof AttachPopupView)) {
                BasePopupView.this.initAnimator();
                BasePopupView.this.doShowAnimation();
                BasePopupView.this.doAfterShow();
            }
        }
    };
    private boolean hasMoveUp = false;
    private Runnable attachTask = new Runnable(){

        @Override
        public void run() {
            BasePopupView.this.attachToHost();
            KeyboardUtils.registerSoftInputChangedListener(BasePopupView.this.getHostWindow(), BasePopupView.this, new KeyboardUtils.OnSoftInputChangedListener(){

                @Override
                public void onSoftInputChanged(int height) {
                    if (BasePopupView.this.popupInfo != null && BasePopupView.this.popupInfo.xPopupCallback != null) {
                        BasePopupView.this.popupInfo.xPopupCallback.onKeyBoardStateChanged(BasePopupView.this, height);
                    }
                    if (height == 0) {
                        XPopupUtils.moveDown(BasePopupView.this);
                        BasePopupView.this.hasMoveUp = false;
                    } else {
                        if (BasePopupView.this instanceof FullScreenPopupView && BasePopupView.this.popupStatus == PopupStatus.Showing) {
                            return;
                        }
                        if (BasePopupView.this instanceof PartShadowPopupView && BasePopupView.this.popupStatus == PopupStatus.Showing) {
                            return;
                        }
                        XPopupUtils.moveUpToKeyboard(height, BasePopupView.this);
                        BasePopupView.this.hasMoveUp = true;
                    }
                }
            });
            BasePopupView.this.init();
        }
    };
    public FullScreenDialog dialog;
    private Runnable doAfterShowTask = new Runnable(){

        @Override
        public void run() {
            BasePopupView.this.popupStatus = PopupStatus.Show;
            BasePopupView.this.onShow();
            if (BasePopupView.this.popupInfo != null && BasePopupView.this.popupInfo.xPopupCallback != null) {
                BasePopupView.this.popupInfo.xPopupCallback.onShow(BasePopupView.this);
            }
            if (XPopupUtils.getDecorViewInvisibleHeight(BasePopupView.this.getHostWindow()) > 0 && !BasePopupView.this.hasMoveUp) {
                XPopupUtils.moveUpToKeyboard(XPopupUtils.getDecorViewInvisibleHeight(BasePopupView.this.getHostWindow()), BasePopupView.this);
            }
        }
    };
    private ShowSoftInputTask showSoftInputTask;
    private Runnable doAfterDismissTask = new Runnable(){

        @Override
        public void run() {
            View needFocusView;
            if (BasePopupView.this.popupInfo == null) {
                return;
            }
            if (BasePopupView.this.popupInfo.autoOpenSoftInput.booleanValue() && BasePopupView.this instanceof PartShadowPopupView) {
                KeyboardUtils.hideSoftInput((View)BasePopupView.this);
            }
            BasePopupView.this.onDismiss();
            XPopup.longClickPoint = null;
            if (BasePopupView.this.popupInfo.xPopupCallback != null) {
                BasePopupView.this.popupInfo.xPopupCallback.onDismiss(BasePopupView.this);
            }
            if (BasePopupView.this.dismissWithRunnable != null) {
                BasePopupView.this.dismissWithRunnable.run();
                BasePopupView.this.dismissWithRunnable = null;
            }
            BasePopupView.this.popupStatus = PopupStatus.Dismiss;
            if (BasePopupView.this.popupInfo.isRequestFocus && BasePopupView.this.popupInfo.decorView != null && (needFocusView = BasePopupView.this.popupInfo.decorView.findViewById(0x1020002)) != null) {
                needFocusView.setFocusable(true);
                needFocusView.setFocusableInTouchMode(true);
            }
            BasePopupView.this.detachFromHost();
        }
    };
    Runnable dismissWithRunnable;
    private float x;
    private float y;

    public BasePopupView(@NonNull Context context) {
        super(context);
        if (context instanceof Application) {
            throw new IllegalArgumentException("XPopup\u7684Context\u5fc5\u987b\u662fActivity\u7c7b\u578b\uff01");
        }
        this.touchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.shadowBgAnimator = new ShadowBgAnimator((View)this);
        View contentView = LayoutInflater.from((Context)context).inflate(this.getPopupLayoutId(), (ViewGroup)this, false);
        contentView.setAlpha(0.0f);
        this.addView(contentView);
    }

    protected void init() {
        if (this instanceof AttachPopupView || this instanceof PartShadowPopupView) {
            this.initPopupContent();
        } else if (!this.isCreated) {
            this.initPopupContent();
        }
        if (!this.isCreated) {
            this.isCreated = true;
            this.onCreate();
            if (this.popupInfo.xPopupCallback != null) {
                this.popupInfo.xPopupCallback.onCreated(this);
            }
        }
        this.handler.postDelayed(this.initTask, 10L);
    }

    protected void initAnimator() {
        this.getPopupContentView().setAlpha(1.0f);
        if (this.popupInfo.customAnimator != null) {
            this.popupContentAnimator = this.popupInfo.customAnimator;
            this.popupContentAnimator.targetView = this.getPopupContentView();
        } else {
            this.popupContentAnimator = this.genAnimatorByPopupType();
            if (this.popupContentAnimator == null) {
                this.popupContentAnimator = this.getPopupAnimator();
            }
        }
        if (this.popupInfo.hasShadowBg.booleanValue()) {
            this.shadowBgAnimator.initAnimator();
        }
        if (this.popupInfo.hasBlurBg.booleanValue()) {
            this.blurAnimator = new BlurAnimator((View)this);
            this.blurAnimator.hasShadowBg = this.popupInfo.hasShadowBg;
            this.blurAnimator.decorBitmap = XPopupUtils.view2Bitmap(XPopupUtils.context2Activity((View)this).getWindow().getDecorView());
            this.blurAnimator.initAnimator();
        }
        if (this.popupContentAnimator != null) {
            this.popupContentAnimator.initAnimator();
        }
    }

    public BasePopupView show() {
        Activity activity = XPopupUtils.context2Activity((View)this);
        if (activity == null || activity.isFinishing()) {
            return this;
        }
        if (this.popupStatus == PopupStatus.Showing) {
            return this;
        }
        this.popupStatus = PopupStatus.Showing;
        if (this.dialog != null && this.dialog.isShowing()) {
            return this;
        }
        this.handler.post(this.attachTask);
        return this;
    }

    private void attachToHost() {
        if (this.dialog == null) {
            this.dialog = new FullScreenDialog(this.getContext()).setContent(this);
        }
        if (this.getContext() instanceof FragmentActivity) {
            ((FragmentActivity)this.getContext()).getLifecycle().addObserver((LifecycleObserver)this);
        }
        this.dialog.show();
        if (this.popupInfo == null) {
            throw new IllegalArgumentException("\u5982\u679c\u5f39\u7a97\u5bf9\u8c61\u662f\u590d\u7528\u7684\uff0c\u5219\u4e0d\u8981\u8bbe\u7f6eisDestroyOnDismiss(true)");
        }
        this.popupInfo.decorView = (ViewGroup)this.getHostWindow().getDecorView();
    }

    private void detachFromHost() {
        if (this.dialog != null) {
            this.dialog.dismiss();
        }
    }

    public Window getHostWindow() {
        return this.dialog.getWindow();
    }

    protected void doAfterShow() {
        this.handler.removeCallbacks(this.doAfterShowTask);
        this.handler.postDelayed(this.doAfterShowTask, (long)this.getAnimationDuration());
    }

    public void focusAndProcessBackPress() {
        if (this.popupInfo != null && this.popupInfo.isRequestFocus) {
            this.setFocusableInTouchMode(true);
            this.requestFocus();
            this.setOnKeyListener(new BackPressListener());
            if (!this.popupInfo.autoFocusEditText) {
                this.showSoftInput((View)this);
            }
            ArrayList<EditText> list = new ArrayList<EditText>();
            XPopupUtils.findAllEditText(list, (ViewGroup)this.getPopupContentView());
            for (int i = 0; i < list.size(); ++i) {
                EditText et = list.get(i);
                et.setOnKeyListener((View.OnKeyListener)new BackPressListener());
                if (i != 0 || !this.popupInfo.autoFocusEditText) continue;
                et.setFocusable(true);
                et.setFocusableInTouchMode(true);
                et.requestFocus();
                this.showSoftInput((View)et);
            }
        }
    }

    protected void showSoftInput(View focusView) {
        if (this.popupInfo.autoOpenSoftInput.booleanValue()) {
            if (this.showSoftInputTask == null) {
                this.showSoftInputTask = new ShowSoftInputTask(focusView);
            } else {
                this.handler.removeCallbacks((Runnable)this.showSoftInputTask);
            }
            this.handler.postDelayed((Runnable)this.showSoftInputTask, 10L);
        }
    }

    public void dismissOrHideSoftInput() {
        if (KeyboardUtils.sDecorViewInvisibleHeightPre == 0) {
            this.dismiss();
        } else {
            KeyboardUtils.hideSoftInput((View)this);
        }
    }

    protected PopupAnimator genAnimatorByPopupType() {
        if (this.popupInfo == null || this.popupInfo.popupAnimation == null) {
            return null;
        }
        switch (this.popupInfo.popupAnimation) {
            case ScaleAlphaFromCenter: 
            case ScaleAlphaFromLeftTop: 
            case ScaleAlphaFromRightTop: 
            case ScaleAlphaFromLeftBottom: 
            case ScaleAlphaFromRightBottom: {
                return new ScaleAlphaAnimator(this.getPopupContentView(), this.popupInfo.popupAnimation);
            }
            case TranslateAlphaFromLeft: 
            case TranslateAlphaFromTop: 
            case TranslateAlphaFromRight: 
            case TranslateAlphaFromBottom: {
                return new TranslateAlphaAnimator(this.getPopupContentView(), this.popupInfo.popupAnimation);
            }
            case TranslateFromLeft: 
            case TranslateFromTop: 
            case TranslateFromRight: 
            case TranslateFromBottom: {
                return new TranslateAnimator(this.getPopupContentView(), this.popupInfo.popupAnimation);
            }
            case ScrollAlphaFromLeft: 
            case ScrollAlphaFromLeftTop: 
            case ScrollAlphaFromTop: 
            case ScrollAlphaFromRightTop: 
            case ScrollAlphaFromRight: 
            case ScrollAlphaFromRightBottom: 
            case ScrollAlphaFromBottom: 
            case ScrollAlphaFromLeftBottom: {
                return new ScrollScaleAnimator(this.getPopupContentView(), this.popupInfo.popupAnimation);
            }
            case NoAnimation: {
                return new EmptyAnimator(this.getPopupContentView());
            }
        }
        return null;
    }

    protected abstract int getPopupLayoutId();

    protected int getImplLayoutId() {
        return -1;
    }

    protected PopupAnimator getPopupAnimator() {
        return null;
    }

    protected void initPopupContent() {
    }

    protected void onCreate() {
    }

    protected void applyDarkTheme() {
    }

    protected void applyLightTheme() {
    }

    protected void doShowAnimation() {
        if (this.popupInfo.hasShadowBg.booleanValue() && !this.popupInfo.hasBlurBg.booleanValue()) {
            this.shadowBgAnimator.animateShow();
        } else if (this.popupInfo.hasBlurBg.booleanValue() && this.blurAnimator != null) {
            this.blurAnimator.animateShow();
        }
        if (this.popupContentAnimator != null) {
            this.popupContentAnimator.animateShow();
        }
    }

    protected void doDismissAnimation() {
        if (this.popupInfo.hasShadowBg.booleanValue() && !this.popupInfo.hasBlurBg.booleanValue()) {
            this.shadowBgAnimator.animateDismiss();
        } else if (this.popupInfo.hasBlurBg.booleanValue() && this.blurAnimator != null) {
            this.blurAnimator.animateDismiss();
        }
        if (this.popupContentAnimator != null) {
            this.popupContentAnimator.animateDismiss();
        }
    }

    public View getPopupContentView() {
        return this.getChildAt(0);
    }

    public View getPopupImplView() {
        return ((ViewGroup)this.getPopupContentView()).getChildAt(0);
    }

    public int getAnimationDuration() {
        return this.popupInfo.popupAnimation == PopupAnimation.NoAnimation ? 10 : XPopup.getAnimationDuration() + 10;
    }

    protected int getMaxWidth() {
        return this.popupInfo.maxWidth;
    }

    protected int getMaxHeight() {
        return this.popupInfo.maxHeight;
    }

    protected int getPopupWidth() {
        return this.popupInfo.popupWidth;
    }

    protected int getPopupHeight() {
        return this.popupInfo.popupHeight;
    }

    public void dismiss() {
        this.handler.removeCallbacks(this.attachTask);
        this.handler.removeCallbacks(this.initTask);
        if (this.popupStatus == PopupStatus.Dismissing || this.popupStatus == PopupStatus.Dismiss) {
            return;
        }
        this.popupStatus = PopupStatus.Dismissing;
        this.clearFocus();
        if (this.popupInfo != null && this.popupInfo.xPopupCallback != null) {
            this.popupInfo.xPopupCallback.beforeDismiss(this);
        }
        this.beforeDismiss();
        this.doDismissAnimation();
        this.doAfterDismiss();
    }

    public void smartDismiss() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                BasePopupView.this.delayDismiss(XPopup.getAnimationDuration() + 50);
            }
        });
    }

    public void delayDismiss(long delay) {
        if (delay < 0L) {
            delay = 0L;
        }
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                BasePopupView.this.dismiss();
            }
        }, delay);
    }

    public void delayDismissWith(long delay, Runnable runnable) {
        this.dismissWithRunnable = runnable;
        this.delayDismiss(delay);
    }

    protected void doAfterDismiss() {
        if (this.popupInfo != null && this.popupInfo.autoOpenSoftInput.booleanValue() && !(this instanceof PartShadowPopupView)) {
            KeyboardUtils.hideSoftInput((View)this);
        }
        this.handler.removeCallbacks(this.doAfterDismissTask);
        this.handler.postDelayed(this.doAfterDismissTask, (long)this.getAnimationDuration());
    }

    public void dismissWith(Runnable runnable) {
        this.dismissWithRunnable = runnable;
        this.dismiss();
    }

    public boolean isShow() {
        return this.popupStatus != PopupStatus.Dismiss;
    }

    public boolean isDismiss() {
        return this.popupStatus == PopupStatus.Dismiss;
    }

    public void toggle() {
        if (this.isShow()) {
            this.dismiss();
        } else {
            this.show();
        }
    }

    protected void onDismiss() {
    }

    protected void beforeDismiss() {
    }

    protected void onShow() {
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public void onDestroy() {
        this.destroy();
    }

    public void destroy() {
        this.detachFromHost();
        this.onDetachedFromWindow();
        if (this.popupInfo != null) {
            this.popupInfo.atView = null;
            this.popupInfo.watchView = null;
            this.popupInfo.xPopupCallback = null;
            this.popupInfo.decorView = null;
            this.dialog = null;
            if (this.popupInfo.isDestroyOnDismiss) {
                this.popupInfo = null;
            }
        }
        if (this.getContext() != null && this.getContext() instanceof FragmentActivity) {
            ((FragmentActivity)this.getContext()).getLifecycle().removeObserver((LifecycleObserver)this);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.handler.removeCallbacksAndMessages(null);
        if (this.popupInfo != null) {
            if (this.popupInfo.decorView != null) {
                KeyboardUtils.removeLayoutChangeListener((View)this.popupInfo.decorView, this);
            }
            if (this.popupInfo.isDestroyOnDismiss) {
                this.popupInfo.atView = null;
                this.popupInfo.watchView = null;
                this.popupInfo.xPopupCallback = null;
                this.popupInfo.decorView = null;
                this.popupInfo = null;
                this.dialog = null;
                if (this.getContext() instanceof FragmentActivity) {
                    ((FragmentActivity)this.getContext()).getLifecycle().removeObserver((LifecycleObserver)this);
                }
                if (this.blurAnimator != null && this.blurAnimator.decorBitmap != null && !this.blurAnimator.decorBitmap.isRecycled()) {
                    this.blurAnimator.decorBitmap.recycle();
                    this.blurAnimator.decorBitmap = null;
                }
            }
        }
        this.popupStatus = PopupStatus.Dismiss;
        this.showSoftInputTask = null;
        this.hasMoveUp = false;
    }

    private void passClickThrough(MotionEvent event) {
        if (this.dialog != null && this.popupInfo != null && this.popupInfo.isClickThrough) {
            this.dialog.passClick(event);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        this.getPopupContentView().getGlobalVisibleRect(rect);
        if (!XPopupUtils.isInRect(event.getX(), event.getY(), rect)) {
            switch (event.getAction()) {
                case 0: {
                    this.x = event.getX();
                    this.y = event.getY();
                    this.passClickThrough(event);
                    break;
                }
                case 1: 
                case 3: {
                    float dx = event.getX() - this.x;
                    float dy = event.getY() - this.y;
                    float distance = (float)Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0));
                    if (distance < (float)this.touchSlop && this.popupInfo.isDismissOnTouchOutside.booleanValue()) {
                        this.dismiss();
                        this.getPopupImplView().getGlobalVisibleRect(rect2);
                        if (!XPopupUtils.isInRect(event.getX(), event.getY(), rect2)) {
                            this.passClickThrough(event);
                        }
                    }
                    this.x = 0.0f;
                    this.y = 0.0f;
                }
            }
        }
        return true;
    }

    class BackPressListener
    implements View.OnKeyListener {
        BackPressListener() {
        }

        public boolean onKey(View v, int keyCode, KeyEvent event) {
            if (keyCode == 4 && event.getAction() == 1 && BasePopupView.this.popupInfo != null) {
                if (BasePopupView.this.popupInfo.isDismissOnBackPressed.booleanValue() && (BasePopupView.this.popupInfo.xPopupCallback == null || !BasePopupView.this.popupInfo.xPopupCallback.onBackPressed(BasePopupView.this))) {
                    BasePopupView.this.dismissOrHideSoftInput();
                }
                return true;
            }
            return false;
        }
    }

    static class ShowSoftInputTask
    implements Runnable {
        View focusView;
        boolean isDone = false;

        public ShowSoftInputTask(View focusView) {
            this.focusView = focusView;
        }

        @Override
        public void run() {
            if (this.focusView != null && !this.isDone) {
                this.isDone = true;
                KeyboardUtils.showSoftInput(this.focusView);
            }
        }
    }
}

