/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.impl;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.lxj.easyadapter.EasyAdapter;
import com.lxj.easyadapter.MultiItemTypeAdapter;
import com.lxj.easyadapter.ViewHolder;
import com.lxj.xpopup.R;
import com.lxj.xpopup.XPopup;
import com.lxj.xpopup.core.CenterPopupView;
import com.lxj.xpopup.interfaces.OnSelectListener;
import com.lxj.xpopup.util.XPopupUtils;
import com.lxj.xpopup.widget.CheckView;
import com.lxj.xpopup.widget.VerticalRecyclerView;
import java.util.Arrays;

public class CenterListPopupView
extends CenterPopupView {
    RecyclerView recyclerView;
    TextView tv_title;
    CharSequence title;
    String[] data;
    int[] iconIds;
    private OnSelectListener selectListener;
    int checkedPosition = -1;

    public CenterListPopupView(@NonNull Context context, int bindLayoutId, int bindItemLayoutId) {
        super(context);
        this.bindLayoutId = bindLayoutId;
        this.bindItemLayoutId = bindItemLayoutId;
        this.addInnerContent();
    }

    @Override
    protected int getImplLayoutId() {
        return this.bindLayoutId == 0 ? R.layout._xpopup_center_impl_list : this.bindLayoutId;
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recyclerView);
        if (this.bindLayoutId != 0) {
            this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        }
        this.tv_title = (TextView)this.findViewById(R.id.tv_title);
        if (this.tv_title != null) {
            if (TextUtils.isEmpty((CharSequence)this.title)) {
                this.tv_title.setVisibility(8);
                if (this.findViewById(R.id.xpopup_divider) != null) {
                    this.findViewById(R.id.xpopup_divider).setVisibility(8);
                }
            } else {
                this.tv_title.setText(this.title);
            }
        }
        EasyAdapter<String> adapter = new EasyAdapter<String>(Arrays.asList(this.data), this.bindItemLayoutId == 0 ? R.layout._xpopup_adapter_text_match : this.bindItemLayoutId){

            protected void bind(@NonNull ViewHolder holder, @NonNull String s, int position) {
                holder.setText(R.id.tv_text, (CharSequence)s);
                ImageView imageView = (ImageView)holder.getViewOrNull(R.id.iv_image);
                if (CenterListPopupView.this.iconIds != null && CenterListPopupView.this.iconIds.length > position) {
                    if (imageView != null) {
                        imageView.setVisibility(0);
                        imageView.setBackgroundResource(CenterListPopupView.this.iconIds[position]);
                    }
                } else if (imageView != null) {
                    imageView.setVisibility(8);
                }
                if (CenterListPopupView.this.bindItemLayoutId == 0) {
                    if (CenterListPopupView.this.popupInfo.isDarkTheme) {
                        ((TextView)holder.getView(R.id.tv_text)).setTextColor(CenterListPopupView.this.getResources().getColor(R.color._xpopup_white_color));
                    } else {
                        ((TextView)holder.getView(R.id.tv_text)).setTextColor(CenterListPopupView.this.getResources().getColor(R.color._xpopup_dark_color));
                    }
                }
                if (CenterListPopupView.this.checkedPosition != -1) {
                    if (holder.getViewOrNull(R.id.check_view) != null) {
                        holder.getView(R.id.check_view).setVisibility(position == CenterListPopupView.this.checkedPosition ? 0 : 8);
                        ((CheckView)holder.getView(R.id.check_view)).setColor(XPopup.getPrimaryColor());
                    }
                    ((TextView)holder.getView(R.id.tv_text)).setTextColor(position == CenterListPopupView.this.checkedPosition ? XPopup.getPrimaryColor() : CenterListPopupView.this.getResources().getColor(R.color._xpopup_title_color));
                    ((TextView)holder.getView(R.id.tv_text)).setGravity(XPopupUtils.isLayoutRtl(CenterListPopupView.this.getContext()) ? 0x800005 : 0x800003);
                } else {
                    if (holder.getViewOrNull(R.id.check_view) != null) {
                        holder.getView(R.id.check_view).setVisibility(8);
                    }
                    ((TextView)holder.getView(R.id.tv_text)).setGravity(17);
                }
            }
        };
        adapter.setOnItemClickListener((MultiItemTypeAdapter.OnItemClickListener)new MultiItemTypeAdapter.SimpleOnItemClickListener((EasyAdapter)adapter){
            final /* synthetic */ EasyAdapter val$adapter;
            {
                this.val$adapter = easyAdapter;
            }

            public void onItemClick(View view, RecyclerView.ViewHolder holder, int position) {
                if (CenterListPopupView.this.selectListener != null && position >= 0 && position < this.val$adapter.getData().size()) {
                    CenterListPopupView.this.selectListener.onSelect(position, (String)this.val$adapter.getData().get(position));
                }
                if (CenterListPopupView.this.checkedPosition != -1) {
                    CenterListPopupView.this.checkedPosition = position;
                    this.val$adapter.notifyDataSetChanged();
                }
                if (CenterListPopupView.this.popupInfo.autoDismiss.booleanValue()) {
                    CenterListPopupView.this.dismiss();
                }
            }
        });
        this.recyclerView.setAdapter((RecyclerView.Adapter)adapter);
        this.applyTheme();
    }

    @Override
    protected void applyDarkTheme() {
        super.applyDarkTheme();
        ((VerticalRecyclerView)this.recyclerView).setupDivider(true);
        this.tv_title.setTextColor(this.getResources().getColor(R.color._xpopup_white_color));
        this.findViewById(R.id.xpopup_divider).setBackgroundColor(this.getResources().getColor(R.color._xpopup_list_dark_divider));
    }

    @Override
    protected void applyLightTheme() {
        super.applyLightTheme();
        ((VerticalRecyclerView)this.recyclerView).setupDivider(false);
        this.tv_title.setTextColor(this.getResources().getColor(R.color._xpopup_dark_color));
        this.findViewById(R.id.xpopup_divider).setBackgroundColor(this.getResources().getColor(R.color._xpopup_list_divider));
    }

    public CenterListPopupView setStringData(CharSequence title, String[] data, int[] iconIds) {
        this.title = title;
        this.data = data;
        this.iconIds = iconIds;
        return this;
    }

    public CenterListPopupView setOnSelectListener(OnSelectListener selectListener) {
        this.selectListener = selectListener;
        return this;
    }

    public CenterListPopupView setCheckedPosition(int position) {
        this.checkedPosition = position;
        if (this.recyclerView != null && this.recyclerView.getAdapter() != null) {
            this.recyclerView.getAdapter().notifyDataSetChanged();
        }
        return this;
    }

    @Override
    protected int getMaxWidth() {
        if (this.popupInfo == null) {
            return 0;
        }
        return this.popupInfo.maxWidth == 0 ? super.getMaxWidth() : this.popupInfo.maxWidth;
    }
}

