/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.util;

import com.lxj.xpopup.enums.ImageType;
import java.io.IOException;
import java.io.InputStream;

public class ImageHeaderParser {
    private static final int GIF_HEADER = 4671814;
    private static final int PNG_HEADER = -1991225785;
    static final int EXIF_MAGIC_NUMBER = 65496;
    private static final int RIFF_HEADER = 1380533830;
    private static final int WEBP_HEADER = 1464156752;
    private static final int VP8_HEADER = 1448097792;
    private static final int VP8_HEADER_MASK = -256;
    private static final int VP8_HEADER_TYPE_MASK = 255;
    private static final int VP8_HEADER_TYPE_EXTENDED = 88;
    private static final int VP8_HEADER_TYPE_LOSSLESS = 76;
    private static final int WEBP_EXTENDED_ALPHA_FLAG = 16;
    private static final int WEBP_LOSSLESS_ALPHA_FLAG = 8;

    static ImageType getImageType(InputStream is) throws IOException {
        StreamReader reader = new StreamReader(is);
        int firstTwoBytes = reader.getUInt16();
        if (firstTwoBytes == 65496) {
            return ImageType.JPEG;
        }
        int firstFourBytes = firstTwoBytes << 16 & 0xFFFF0000 | reader.getUInt16() & 0xFFFF;
        if (firstFourBytes == -1991225785) {
            reader.skip(21L);
            int alpha = reader.getByte();
            return alpha >= 3 ? ImageType.PNG_A : ImageType.PNG;
        }
        if (firstFourBytes >> 8 == 4671814) {
            return ImageType.GIF;
        }
        if (firstFourBytes != 1380533830) {
            return ImageType.UNKNOWN;
        }
        reader.skip(4L);
        int thirdFourBytes = reader.getUInt16() << 16 & 0xFFFF0000 | reader.getUInt16() & 0xFFFF;
        if (thirdFourBytes != 1464156752) {
            return ImageType.UNKNOWN;
        }
        int fourthFourBytes = reader.getUInt16() << 16 & 0xFFFF0000 | reader.getUInt16() & 0xFFFF;
        if ((fourthFourBytes & 0xFFFFFF00) != 1448097792) {
            return ImageType.UNKNOWN;
        }
        if ((fourthFourBytes & 0xFF) == 88) {
            reader.skip(4L);
            return (reader.getByte() & 0x10) != 0 ? ImageType.WEBP_A : ImageType.WEBP;
        }
        if ((fourthFourBytes & 0xFF) == 76) {
            reader.skip(4L);
            return (reader.getByte() & 8) != 0 ? ImageType.WEBP_A : ImageType.WEBP;
        }
        is.close();
        return ImageType.WEBP;
    }

    private static final class StreamReader
    implements Reader {
        private final InputStream is;

        StreamReader(InputStream is) {
            this.is = is;
        }

        @Override
        public int getUInt16() throws IOException {
            return this.is.read() << 8 & 0xFF00 | this.is.read() & 0xFF;
        }

        @Override
        public short getUInt8() throws IOException {
            return (short)(this.is.read() & 0xFF);
        }

        @Override
        public long skip(long total) throws IOException {
            if (total < 0L) {
                return 0L;
            }
            long toSkip = total;
            while (toSkip > 0L) {
                long skipped = this.is.skip(toSkip);
                if (skipped > 0L) {
                    toSkip -= skipped;
                    continue;
                }
                int testEofByte = this.is.read();
                if (testEofByte == -1) break;
                --toSkip;
            }
            return total - toSkip;
        }

        @Override
        public int read(byte[] buffer, int byteCount) throws IOException {
            int toRead;
            int read;
            for (toRead = byteCount; toRead > 0 && (read = this.is.read(buffer, byteCount - toRead, toRead)) != -1; toRead -= read) {
            }
            return byteCount - toRead;
        }

        @Override
        public int getByte() throws IOException {
            return this.is.read();
        }
    }

    private static interface Reader {
        public int getUInt16() throws IOException;

        public short getUInt8() throws IOException;

        public long skip(long var1) throws IOException;

        public int read(byte[] var1, int var2) throws IOException;

        public int getByte() throws IOException;
    }
}

