/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.core;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.lxj.xpopup.R;
import com.lxj.xpopup.animator.PopupAnimator;
import com.lxj.xpopup.animator.TranslateAnimator;
import com.lxj.xpopup.core.BasePopupView;
import com.lxj.xpopup.enums.PopupAnimation;
import com.lxj.xpopup.enums.PopupStatus;
import com.lxj.xpopup.util.KeyboardUtils;
import com.lxj.xpopup.util.XPopupUtils;
import com.lxj.xpopup.widget.SmartDragLayout;

public class BottomPopupView
extends BasePopupView {
    protected SmartDragLayout bottomPopupContainer = (SmartDragLayout)this.findViewById(R.id.bottomPopupContainer);

    public BottomPopupView(@NonNull Context context) {
        super(context);
    }

    protected void addInnerContent() {
        View contentView = LayoutInflater.from((Context)this.getContext()).inflate(this.getImplLayoutId(), (ViewGroup)this.bottomPopupContainer, false);
        this.bottomPopupContainer.addView(contentView);
    }

    @Override
    protected int getPopupLayoutId() {
        return R.layout._xpopup_bottom_popup_view;
    }

    @Override
    protected void initPopupContent() {
        super.initPopupContent();
        if (this.bottomPopupContainer.getChildCount() == 0) {
            this.addInnerContent();
        }
        this.bottomPopupContainer.enableDrag(this.popupInfo.enableDrag);
        this.bottomPopupContainer.dismissOnTouchOutside(this.popupInfo.isDismissOnTouchOutside);
        this.bottomPopupContainer.hasShadowBg(this.popupInfo.hasShadowBg);
        this.bottomPopupContainer.isThreeDrag(this.popupInfo.isThreeDrag);
        this.getPopupImplView().setTranslationX((float)this.popupInfo.offsetX);
        this.getPopupImplView().setTranslationY((float)this.popupInfo.offsetY);
        XPopupUtils.applyPopupSize((ViewGroup)this.getPopupContentView(), this.getMaxWidth(), this.getMaxHeight());
        this.bottomPopupContainer.setOnCloseListener(new SmartDragLayout.OnCloseListener(){

            @Override
            public void onClose() {
                BottomPopupView.this.doAfterDismiss();
            }

            @Override
            public void onOpen() {
                BottomPopupView.super.doAfterShow();
            }
        });
        this.bottomPopupContainer.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BottomPopupView.this.dismiss();
            }
        });
    }

    @Override
    protected void doAfterShow() {
        if (!this.popupInfo.enableDrag.booleanValue()) {
            super.doAfterShow();
        }
    }

    @Override
    public void doShowAnimation() {
        if (this.popupInfo.enableDrag.booleanValue()) {
            this.bottomPopupContainer.open();
        } else {
            super.doShowAnimation();
        }
    }

    @Override
    public void doDismissAnimation() {
        if (this.popupInfo.enableDrag.booleanValue()) {
            this.bottomPopupContainer.close();
        } else {
            super.doDismissAnimation();
        }
    }

    @Override
    public int getAnimationDuration() {
        return this.popupInfo.enableDrag != false ? 0 : super.getAnimationDuration();
    }

    @Override
    protected PopupAnimator getPopupAnimator() {
        return this.popupInfo.enableDrag != false ? null : new TranslateAnimator(this.getPopupContentView(), PopupAnimation.TranslateFromBottom);
    }

    @Override
    public void dismiss() {
        if (this.popupInfo == null) {
            return;
        }
        if (this.popupInfo.enableDrag.booleanValue()) {
            if (this.popupStatus == PopupStatus.Dismissing) {
                return;
            }
            this.popupStatus = PopupStatus.Dismissing;
            if (this.popupInfo.autoOpenSoftInput.booleanValue()) {
                KeyboardUtils.hideSoftInput((View)this);
            }
            this.clearFocus();
            this.bottomPopupContainer.close();
        } else {
            super.dismiss();
        }
    }

    @Override
    protected int getImplLayoutId() {
        return 0;
    }

    @Override
    protected int getMaxWidth() {
        return this.popupInfo.maxWidth == 0 ? XPopupUtils.getWindowWidth(this.getContext()) : this.popupInfo.maxWidth;
    }

    @Override
    protected View getTargetSizeView() {
        return this.getPopupImplView();
    }
}

