/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.impl;

import android.content.Context;
import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import com.lxj.xpopup.animator.PopupAnimator;
import com.lxj.xpopup.animator.TranslateAnimator;
import com.lxj.xpopup.core.AttachPopupView;
import com.lxj.xpopup.enums.PopupAnimation;
import com.lxj.xpopup.enums.PopupPosition;
import com.lxj.xpopup.interfaces.OnClickOutsideListener;
import com.lxj.xpopup.util.XPopupUtils;

public abstract class PartShadowPopupView
extends AttachPopupView {
    public PartShadowPopupView(@NonNull Context context) {
        super(context);
    }

    @Override
    protected void initPopupContent() {
        super.initPopupContent();
        this.defaultOffsetY = this.popupInfo.offsetY == 0 ? this.defaultOffsetY : this.popupInfo.offsetY;
        int n = this.defaultOffsetX = this.popupInfo.offsetX == 0 ? this.defaultOffsetX : this.popupInfo.offsetX;
        if (this.popupInfo.hasShadowBg.booleanValue()) {
            this.shadowBgAnimator.targetView = this.getPopupContentView();
        }
    }

    @Override
    protected void applyBg() {
    }

    @Override
    public void onNavigationBarChange(boolean show) {
        super.onNavigationBarChange(show);
        if (!show) {
            FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.getPopupContentView().getLayoutParams();
            params.height = XPopupUtils.getWindowHeight(this.getContext());
            this.getPopupContentView().setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    @Override
    protected void doAttach() {
        if (this.popupInfo.getAtView() == null) {
            throw new IllegalArgumentException("atView must not be null for PartShadowPopupView\uff01");
        }
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.getPopupContentView().getLayoutParams();
        params.width = this.getMeasuredWidth();
        if (this.popupInfo.isCenterHorizontal && this.getPopupImplView() != null) {
            this.getPopupImplView().setTranslationX((float)XPopupUtils.getWindowWidth(this.getContext()) / 2.0f - (float)this.getPopupContentView().getMeasuredWidth() / 2.0f);
        }
        int[] locations = new int[2];
        this.popupInfo.getAtView().getLocationOnScreen(locations);
        Rect rect = new Rect(locations[0], locations[1], locations[0] + this.popupInfo.getAtView().getMeasuredWidth(), locations[1] + this.popupInfo.getAtView().getMeasuredHeight());
        int centerY = rect.top + rect.height() / 2;
        if ((centerY > this.getMeasuredHeight() / 2 || this.popupInfo.popupPosition == PopupPosition.Top) && this.popupInfo.popupPosition != PopupPosition.Bottom) {
            params.height = rect.top;
            this.isShowUp = true;
            View implView = ((ViewGroup)this.getPopupContentView()).getChildAt(0);
            FrameLayout.LayoutParams implParams = (FrameLayout.LayoutParams)implView.getLayoutParams();
            implParams.gravity = 80;
            if (this.getMaxHeight() != 0) {
                implParams.height = Math.min(implView.getMeasuredHeight(), this.getMaxHeight());
            }
            implView.setLayoutParams((ViewGroup.LayoutParams)implParams);
        } else {
            params.height = this.getMeasuredHeight() - rect.bottom;
            this.isShowUp = false;
            params.topMargin = rect.bottom;
            View implView = ((ViewGroup)this.getPopupContentView()).getChildAt(0);
            FrameLayout.LayoutParams implParams = (FrameLayout.LayoutParams)implView.getLayoutParams();
            implParams.gravity = 48;
            if (this.getMaxHeight() != 0) {
                implParams.height = Math.min(implView.getMeasuredHeight(), this.getMaxHeight());
            }
            implView.setLayoutParams((ViewGroup.LayoutParams)implParams);
        }
        this.getPopupContentView().setLayoutParams((ViewGroup.LayoutParams)params);
        this.attachPopupContainer.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (PartShadowPopupView.this.popupInfo.isDismissOnTouchOutside.booleanValue()) {
                    PartShadowPopupView.this.dismiss();
                }
                return false;
            }
        });
        this.attachPopupContainer.setOnClickOutsideListener(new OnClickOutsideListener(){

            @Override
            public void onClickOutside() {
                if (PartShadowPopupView.this.popupInfo.isDismissOnTouchOutside.booleanValue()) {
                    PartShadowPopupView.this.dismiss();
                }
            }
        });
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if (this.popupInfo.isDismissOnTouchOutside.booleanValue()) {
            this.dismiss();
        }
        if (this.dialog != null && this.popupInfo.isClickThrough) {
            this.dialog.passClick(event);
        }
        return this.popupInfo.isClickThrough;
    }

    @Override
    protected PopupAnimator getPopupAnimator() {
        return new TranslateAnimator(this.getPopupImplView(), this.isShowUp ? PopupAnimation.TranslateFromBottom : PopupAnimation.TranslateFromTop);
    }
}

