/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.animator;

import android.animation.FloatEvaluator;
import android.animation.IntEvaluator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.view.View;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import com.lxj.xpopup.XPopup;
import com.lxj.xpopup.animator.PopupAnimator;
import com.lxj.xpopup.enums.PopupAnimation;

public class ScrollScaleAnimator
extends PopupAnimator {
    private FloatEvaluator floatEvaluator = new FloatEvaluator();
    private IntEvaluator intEvaluator = new IntEvaluator();
    private int startScrollX;
    private int startScrollY;
    private float startAlpha = 0.2f;
    private float startScale = 0.0f;
    public boolean isOnlyScaleX = false;

    public ScrollScaleAnimator(View target, PopupAnimation popupAnimation) {
        super(target, popupAnimation);
    }

    @Override
    public void initAnimator() {
        this.targetView.setAlpha(this.startAlpha);
        this.targetView.setScaleX(this.startScale);
        if (!this.isOnlyScaleX) {
            this.targetView.setScaleY(this.startScale);
        }
        this.targetView.post(new Runnable(){

            @Override
            public void run() {
                ScrollScaleAnimator.this.applyPivot();
                ScrollScaleAnimator.this.targetView.scrollTo(ScrollScaleAnimator.this.startScrollX, ScrollScaleAnimator.this.startScrollY);
                if (ScrollScaleAnimator.this.targetView.getBackground() != null) {
                    ScrollScaleAnimator.this.targetView.getBackground().setAlpha(0);
                }
            }
        });
    }

    private void applyPivot() {
        switch (this.popupAnimation) {
            case ScrollAlphaFromLeft: {
                this.targetView.setPivotX(0.0f);
                this.targetView.setPivotY((float)(this.targetView.getMeasuredHeight() / 2));
                this.startScrollX = this.targetView.getMeasuredWidth();
                this.startScrollY = 0;
                break;
            }
            case ScrollAlphaFromLeftTop: {
                this.targetView.setPivotX(0.0f);
                this.targetView.setPivotY(0.0f);
                this.startScrollX = this.targetView.getMeasuredWidth();
                this.startScrollY = this.targetView.getMeasuredHeight();
                break;
            }
            case ScrollAlphaFromTop: {
                this.targetView.setPivotX((float)(this.targetView.getMeasuredWidth() / 2));
                this.targetView.setPivotY(0.0f);
                this.startScrollY = this.targetView.getMeasuredHeight();
                break;
            }
            case ScrollAlphaFromRightTop: {
                this.targetView.setPivotX((float)this.targetView.getMeasuredWidth());
                this.targetView.setPivotY(0.0f);
                this.startScrollX = -this.targetView.getMeasuredWidth();
                this.startScrollY = this.targetView.getMeasuredHeight();
                break;
            }
            case ScrollAlphaFromRight: {
                this.targetView.setPivotX((float)this.targetView.getMeasuredWidth());
                this.targetView.setPivotY((float)(this.targetView.getMeasuredHeight() / 2));
                this.startScrollX = -this.targetView.getMeasuredWidth();
                break;
            }
            case ScrollAlphaFromRightBottom: {
                this.targetView.setPivotX((float)this.targetView.getMeasuredWidth());
                this.targetView.setPivotY((float)this.targetView.getMeasuredHeight());
                this.startScrollX = -this.targetView.getMeasuredWidth();
                this.startScrollY = -this.targetView.getMeasuredHeight();
                break;
            }
            case ScrollAlphaFromBottom: {
                this.targetView.setPivotX((float)(this.targetView.getMeasuredWidth() / 2));
                this.targetView.setPivotY((float)this.targetView.getMeasuredHeight());
                this.startScrollY = -this.targetView.getMeasuredHeight();
                break;
            }
            case ScrollAlphaFromLeftBottom: {
                this.targetView.setPivotX(0.0f);
                this.targetView.setPivotY((float)this.targetView.getMeasuredHeight());
                this.startScrollX = this.targetView.getMeasuredWidth();
                this.startScrollY = -this.targetView.getMeasuredHeight();
            }
        }
    }

    @Override
    public void animateShow() {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float fraction = animation.getAnimatedFraction();
                ScrollScaleAnimator.this.targetView.setAlpha(ScrollScaleAnimator.this.floatEvaluator.evaluate(fraction, (Number)Float.valueOf(ScrollScaleAnimator.this.startAlpha), (Number)Float.valueOf(1.0f)).floatValue());
                ScrollScaleAnimator.this.targetView.scrollTo(ScrollScaleAnimator.this.intEvaluator.evaluate(fraction, Integer.valueOf(ScrollScaleAnimator.this.startScrollX), Integer.valueOf(0)).intValue(), ScrollScaleAnimator.this.intEvaluator.evaluate(fraction, Integer.valueOf(ScrollScaleAnimator.this.startScrollY), Integer.valueOf(0)).intValue());
                float scale = ScrollScaleAnimator.this.floatEvaluator.evaluate(fraction, (Number)Float.valueOf(ScrollScaleAnimator.this.startScale), (Number)Float.valueOf(1.0f)).floatValue();
                ScrollScaleAnimator.this.targetView.setScaleX(scale);
                if (!ScrollScaleAnimator.this.isOnlyScaleX) {
                    ScrollScaleAnimator.this.targetView.setScaleY(scale);
                }
                if (fraction >= 0.9f && ScrollScaleAnimator.this.targetView.getBackground() != null) {
                    float alphaFraction = (fraction - 0.9f) / 0.1f;
                    ScrollScaleAnimator.this.targetView.getBackground().setAlpha((int)(alphaFraction * 255.0f));
                }
            }
        });
        animator.setDuration((long)XPopup.getAnimationDuration()).setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
        animator.start();
    }

    @Override
    public void animateDismiss() {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float fraction = animation.getAnimatedFraction();
                ScrollScaleAnimator.this.targetView.setAlpha(ScrollScaleAnimator.this.floatEvaluator.evaluate(fraction, (Number)Float.valueOf(1.0f), (Number)Float.valueOf(ScrollScaleAnimator.this.startAlpha)).floatValue());
                ScrollScaleAnimator.this.targetView.scrollTo(ScrollScaleAnimator.this.intEvaluator.evaluate(fraction, Integer.valueOf(0), Integer.valueOf(ScrollScaleAnimator.this.startScrollX)).intValue(), ScrollScaleAnimator.this.intEvaluator.evaluate(fraction, Integer.valueOf(0), Integer.valueOf(ScrollScaleAnimator.this.startScrollY)).intValue());
                float scale = ScrollScaleAnimator.this.floatEvaluator.evaluate(fraction, (Number)Float.valueOf(1.0f), (Number)Float.valueOf(ScrollScaleAnimator.this.startScale)).floatValue();
                ScrollScaleAnimator.this.targetView.setScaleX(scale);
                if (!ScrollScaleAnimator.this.isOnlyScaleX) {
                    ScrollScaleAnimator.this.targetView.setScaleY(scale);
                }
                if (ScrollScaleAnimator.this.targetView.getBackground() != null) {
                    ScrollScaleAnimator.this.targetView.getBackground().setAlpha((int)(fraction * 255.0f));
                }
            }
        });
        animator.setDuration((long)XPopup.getAnimationDuration()).setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
        animator.start();
    }
}

