/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.core;

import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import androidx.annotation.NonNull;
import com.lxj.xpopup.animator.PopupAnimator;
import com.lxj.xpopup.animator.ScrollScaleAnimator;
import com.lxj.xpopup.core.AttachPopupView;
import com.lxj.xpopup.enums.PopupAnimation;
import com.lxj.xpopup.enums.PopupPosition;
import com.lxj.xpopup.util.XPopupUtils;

public class HorizontalAttachPopupView
extends AttachPopupView {
    public HorizontalAttachPopupView(@NonNull Context context) {
        super(context);
    }

    @Override
    protected void initPopupContent() {
        super.initPopupContent();
        this.defaultOffsetY = this.popupInfo.offsetY == 0 ? XPopupUtils.dp2px(this.getContext(), 0.0f) : this.popupInfo.offsetY;
        int n = this.defaultOffsetX = this.popupInfo.offsetX == 0 ? XPopupUtils.dp2px(this.getContext(), 4.0f) : this.popupInfo.offsetX;
        if (!this.popupInfo.hasShadowBg.booleanValue() && Build.VERSION.SDK_INT < 21 && this.getPopupBackground() == null) {
            this.defaultOffsetX -= this.bgDrawableMargin;
            this.defaultOffsetY -= this.bgDrawableMargin;
        }
    }

    @Override
    protected void doAttach() {
        float translationX = 0.0f;
        float translationY = 0.0f;
        int w = this.getPopupContentView().getMeasuredWidth();
        int h = this.getPopupContentView().getMeasuredHeight();
        if (this.popupInfo.touchPoint != null) {
            this.isShowLeft = this.popupInfo.touchPoint.x > (float)(XPopupUtils.getWindowWidth(this.getContext()) / 2);
            translationX = this.isShowLeftToTarget() ? this.popupInfo.touchPoint.x - (float)w - (float)this.defaultOffsetX : this.popupInfo.touchPoint.x + (float)this.defaultOffsetX;
            translationY = this.popupInfo.touchPoint.y - (float)h * 0.5f + (float)this.defaultOffsetY;
        } else {
            int[] locations = new int[2];
            this.popupInfo.getAtView().getLocationOnScreen(locations);
            Rect rect = new Rect(locations[0], locations[1], locations[0] + this.popupInfo.getAtView().getMeasuredWidth(), locations[1] + this.popupInfo.getAtView().getMeasuredHeight());
            int centerX = (rect.left + rect.right) / 2;
            this.isShowLeft = centerX > XPopupUtils.getWindowWidth(this.getContext()) / 2;
            translationX = this.isShowLeftToTarget() ? (float)(rect.left - w + this.defaultOffsetX) : (float)(rect.right + this.defaultOffsetX);
            translationY = rect.top + (rect.height() - h) / 2 + this.defaultOffsetY;
        }
        this.getPopupContentView().setTranslationX(translationX);
        this.getPopupContentView().setTranslationY(translationY);
    }

    private boolean isShowLeftToTarget() {
        return (this.isShowLeft || this.popupInfo.popupPosition == PopupPosition.Left) && this.popupInfo.popupPosition != PopupPosition.Right;
    }

    @Override
    protected PopupAnimator getPopupAnimator() {
        ScrollScaleAnimator animator = this.isShowLeftToTarget() ? new ScrollScaleAnimator(this.getPopupContentView(), PopupAnimation.ScrollAlphaFromRight) : new ScrollScaleAnimator(this.getPopupContentView(), PopupAnimation.ScrollAlphaFromLeft);
        animator.isOnlyScaleX = true;
        return animator;
    }
}

