/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;

public class BlankView
extends View {
    private Paint paint = new Paint();
    private RectF rect = null;
    public int radius = 0;
    public int color = -1;
    public int strokeColor = Color.parseColor((String)"#DDDDDD");

    public BlankView(Context context) {
        super(context);
    }

    public BlankView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public BlankView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.paint.setAntiAlias(true);
        this.paint.setStrokeWidth(1.0f);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.rect = new RectF(0.0f, 0.0f, (float)this.getMeasuredWidth(), (float)this.getMeasuredHeight());
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.paint.setColor(this.color);
        canvas.drawRoundRect(this.rect, (float)this.radius, (float)this.radius, this.paint);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setColor(this.strokeColor);
        canvas.drawRoundRect(this.rect, (float)this.radius, (float)this.radius, this.paint);
        this.paint.setStyle(Paint.Style.FILL);
    }
}

