/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.impl;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.lxj.xpopup.R;
import com.lxj.xpopup.XPopup;
import com.lxj.xpopup.core.CenterPopupView;
import com.lxj.xpopup.interfaces.OnCancelListener;
import com.lxj.xpopup.interfaces.OnConfirmListener;

public class ConfirmPopupView
extends CenterPopupView
implements View.OnClickListener {
    OnCancelListener cancelListener;
    OnConfirmListener confirmListener;
    TextView tv_title;
    TextView tv_content;
    TextView tv_cancel;
    TextView tv_confirm;
    CharSequence title;
    CharSequence content;
    CharSequence hint;
    CharSequence cancelText;
    CharSequence confirmText;
    boolean isHideCancel = false;

    public ConfirmPopupView(@NonNull Context context) {
        super(context);
    }

    public ConfirmPopupView bindLayout(int layoutId) {
        this.bindLayoutId = layoutId;
        return this;
    }

    @Override
    protected int getImplLayoutId() {
        return this.bindLayoutId != 0 ? this.bindLayoutId : R.layout._xpopup_center_impl_confirm;
    }

    @Override
    protected void initPopupContent() {
        super.initPopupContent();
        this.tv_title = (TextView)this.findViewById(R.id.tv_title);
        this.tv_content = (TextView)this.findViewById(R.id.tv_content);
        this.tv_cancel = (TextView)this.findViewById(R.id.tv_cancel);
        this.tv_confirm = (TextView)this.findViewById(R.id.tv_confirm);
        if (this.bindLayoutId == 0) {
            this.applyPrimaryColor();
        }
        this.tv_cancel.setOnClickListener((View.OnClickListener)this);
        this.tv_confirm.setOnClickListener((View.OnClickListener)this);
        if (!TextUtils.isEmpty((CharSequence)this.title)) {
            this.tv_title.setText(this.title);
        } else {
            this.tv_title.setVisibility(4);
        }
        if (!TextUtils.isEmpty((CharSequence)this.content)) {
            this.tv_content.setText(this.content);
        } else {
            this.tv_content.setVisibility(8);
        }
        if (!TextUtils.isEmpty((CharSequence)this.cancelText)) {
            this.tv_cancel.setText(this.cancelText);
        }
        if (!TextUtils.isEmpty((CharSequence)this.confirmText)) {
            this.tv_confirm.setText(this.confirmText);
        }
        if (this.isHideCancel) {
            this.tv_cancel.setVisibility(8);
        }
        if (this.bindItemLayoutId == 0 && this.popupInfo.isDarkTheme) {
            this.applyDarkTheme();
        }
    }

    protected void applyPrimaryColor() {
        if (this.bindItemLayoutId == 0) {
            this.tv_confirm.setTextColor(XPopup.getPrimaryColor());
        }
    }

    @Override
    protected void applyDarkTheme() {
        super.applyDarkTheme();
        this.tv_title.setTextColor(this.getResources().getColor(R.color._xpopup_white_color));
        this.tv_content.setTextColor(this.getResources().getColor(R.color._xpopup_white_color));
        this.tv_cancel.setTextColor(this.getResources().getColor(R.color._xpopup_white_color));
        this.tv_confirm.setTextColor(this.getResources().getColor(R.color._xpopup_white_color));
        this.findViewById(R.id.xpopup_divider).setBackgroundColor(this.getResources().getColor(R.color._xpopup_dark_color));
        this.findViewById(R.id.xpopup_divider_h).setBackgroundColor(this.getResources().getColor(R.color._xpopup_dark_color));
        ((ViewGroup)this.tv_title.getParent()).setBackgroundResource(R.drawable._xpopup_round3_dark_bg);
    }

    public ConfirmPopupView setListener(OnConfirmListener confirmListener, OnCancelListener cancelListener) {
        this.cancelListener = cancelListener;
        this.confirmListener = confirmListener;
        return this;
    }

    public ConfirmPopupView setTitleContent(CharSequence title, CharSequence content, CharSequence hint) {
        this.title = title;
        this.content = content;
        this.hint = hint;
        return this;
    }

    public ConfirmPopupView setCancelText(CharSequence cancelText) {
        this.cancelText = cancelText;
        return this;
    }

    public ConfirmPopupView setConfirmText(CharSequence confirmText) {
        this.confirmText = confirmText;
        return this;
    }

    public ConfirmPopupView hideCancelBtn() {
        this.isHideCancel = true;
        return this;
    }

    public void onClick(View v) {
        if (v == this.tv_cancel) {
            if (this.cancelListener != null) {
                this.cancelListener.onCancel();
            }
            this.dismiss();
        } else if (v == this.tv_confirm) {
            if (this.confirmListener != null) {
                this.confirmListener.onConfirm();
            }
            if (this.popupInfo.autoDismiss.booleanValue()) {
                this.dismiss();
            }
        }
    }
}

