/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.core;

import android.animation.ArgbEvaluator;
import android.content.Context;
import android.graphics.Color;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.lxj.xpopup.R;
import com.lxj.xpopup.core.BasePopupView;
import com.lxj.xpopup.widget.PopupDrawerLayout;

public abstract class DrawerPopupView
extends BasePopupView {
    PopupDrawerLayout drawerLayout;
    FrameLayout drawerContentContainer;
    View view_statusbar_shadow;
    boolean isAddStatusBarShadow;
    ArgbEvaluator argbEvaluator = new ArgbEvaluator();
    int defaultColor = 0;
    int shadowColor = Color.parseColor((String)"#55444444");
    PopupDrawerLayout.Position position = PopupDrawerLayout.Position.Left;

    public DrawerPopupView(@NonNull Context context) {
        super(context);
        this.drawerLayout = (PopupDrawerLayout)this.findViewById(R.id.drawerLayout);
        this.view_statusbar_shadow = this.findViewById(R.id.view_statusbar_shadow);
        this.drawerContentContainer = (FrameLayout)this.findViewById(R.id.drawerContentContainer);
        View contentView = LayoutInflater.from((Context)this.getContext()).inflate(this.getImplLayoutId(), (ViewGroup)this.drawerContentContainer, false);
        this.drawerContentContainer.addView(contentView);
    }

    @Override
    protected int getPopupLayoutId() {
        return R.layout._xpopup_drawer_popup_view;
    }

    @Override
    protected void initPopupContent() {
        super.initPopupContent();
        this.drawerLayout.setOnCloseListener(new PopupDrawerLayout.OnCloseListener(){

            @Override
            public void onClose() {
                DrawerPopupView.super.dismiss();
            }

            @Override
            public void onDismissing(float fraction) {
                if (DrawerPopupView.this.isAddStatusBarShadow) {
                    DrawerPopupView.this.view_statusbar_shadow.setBackgroundColor(((Integer)DrawerPopupView.this.argbEvaluator.evaluate(fraction, (Object)DrawerPopupView.this.defaultColor, (Object)DrawerPopupView.this.shadowColor)).intValue());
                }
            }
        });
        this.drawerLayout.setDrawerPosition(this.position);
        this.drawerLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DrawerPopupView.this.drawerLayout.close();
            }
        });
    }

    @Override
    public void doShowAnimation() {
        this.drawerLayout.open();
    }

    @Override
    public void doDismissAnimation() {
        this.drawerLayout.close();
    }

    @Override
    public int getAnimationDuration() {
        return 0;
    }

    @Override
    public void dismiss() {
        this.drawerLayout.close();
    }

    public DrawerPopupView setDrawerPosition(PopupDrawerLayout.Position position) {
        this.position = position;
        return this;
    }

    public DrawerPopupView hasStatusBarShadow(boolean hasStatusBarShadow) {
        this.isAddStatusBarShadow = hasStatusBarShadow;
        return this;
    }
}

