/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.core;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.lxj.xpopup.R;
import com.lxj.xpopup.animator.PopupAnimator;
import com.lxj.xpopup.core.BasePopupView;
import com.lxj.xpopup.util.XPopupUtils;
import com.lxj.xpopup.widget.SmartDragLayout;

public class BottomPopupView
extends BasePopupView {
    SmartDragLayout bottomPopupContainer = (SmartDragLayout)this.findViewById(R.id.bottomPopupContainer);
    boolean enableGesture = true;

    public BottomPopupView(@NonNull Context context) {
        super(context);
        View contentView = LayoutInflater.from((Context)this.getContext()).inflate(this.getImplLayoutId(), (ViewGroup)this.bottomPopupContainer, false);
        this.bottomPopupContainer.addView(contentView);
    }

    @Override
    protected int getPopupLayoutId() {
        return R.layout._xpopup_bottom_popup_view;
    }

    @Override
    protected void initPopupContent() {
        super.initPopupContent();
        this.bottomPopupContainer.enableGesture(this.enableGesture);
        this.bottomPopupContainer.dismissOnTouchOutside(this.popupInfo.isDismissOnTouchOutside);
        this.bottomPopupContainer.hasShadowBg(this.popupInfo.hasShadowBg);
        XPopupUtils.widthAndHeight(this.getPopupImplView(), this.getMaxWidth(), this.getMaxHeight());
        this.bottomPopupContainer.setOnCloseListener(new SmartDragLayout.OnCloseListener(){

            @Override
            public void onClose() {
                BottomPopupView.super.dismiss();
            }
        });
        this.bottomPopupContainer.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BottomPopupView.this.bottomPopupContainer.close();
            }
        });
    }

    @Override
    public void doShowAnimation() {
        if (this.enableGesture) {
            this.bottomPopupContainer.open();
        } else {
            super.doShowAnimation();
        }
    }

    @Override
    public void doDismissAnimation() {
        if (this.enableGesture) {
            this.bottomPopupContainer.close();
        } else {
            super.doDismissAnimation();
        }
    }

    @Override
    public int getAnimationDuration() {
        return this.enableGesture ? 0 : super.getAnimationDuration();
    }

    @Override
    protected PopupAnimator getPopupAnimator() {
        return this.enableGesture ? null : super.getPopupAnimator();
    }

    @Override
    public void dismiss() {
        if (this.enableGesture) {
            this.bottomPopupContainer.close();
        } else {
            super.dismiss();
        }
    }

    @Override
    protected int getImplLayoutId() {
        return 0;
    }

    @Override
    protected int getMaxWidth() {
        return this.popupInfo.maxWidth == 0 ? XPopupUtils.getWindowWidth(this.getContext()) : this.popupInfo.maxWidth;
    }

    public BottomPopupView enableGesture(boolean enableGesture) {
        this.enableGesture = enableGesture;
        return this;
    }
}

