/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.widget;

import android.content.Context;
import android.graphics.Rect;
import android.support.v4.view.NestedScrollingChildHelper;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.CardView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.OverScroller;
import com.lxj.xpopup.animator.ShadowBgAnimator;
import com.lxj.xpopup.util.XPopupUtils;

public class SmartDragLayout
extends CardView
implements NestedScrollingParent {
    private static final String TAG = "SmartDragLayout";
    private View child;
    OverScroller scroller;
    ShadowBgAnimator bgAnimator = new ShadowBgAnimator();
    NestedScrollingChildHelper childHelper;
    int maxY;
    int minY;
    float touchX;
    float touchY;
    long downTime;
    boolean isScrollUp;
    private OnCloseListener listener;

    public SmartDragLayout(Context context) {
        this(context, null);
    }

    public SmartDragLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SmartDragLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.scroller = new OverScroller(context);
        this.setCardElevation(XPopupUtils.dp2px(context, 10.0f));
        this.setBackgroundColor(0);
    }

    public void onViewAdded(View c) {
        super.onViewAdded(c);
        this.child = c;
        this.childHelper = new NestedScrollingChildHelper(this.child);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.maxY = this.child.getMeasuredHeight();
        this.minY = 0;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int l = this.getMeasuredWidth() / 2 - this.child.getMeasuredWidth() / 2;
        this.child.layout(l, this.getMeasuredHeight(), l + this.child.getMeasuredWidth(), this.getMeasuredHeight() + this.child.getMeasuredHeight());
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                if (!this.scroller.isFinished()) {
                    this.scroller.abortAnimation();
                }
                this.touchX = event.getX();
                this.touchY = event.getY();
                this.downTime = System.currentTimeMillis();
                break;
            }
            case 2: {
                int dy = (int)(event.getY() - this.touchY);
                this.scrollTo(this.getScrollX(), this.getScrollY() - dy);
                this.touchY = event.getY();
                break;
            }
            case 1: {
                this.finishScroll();
                Rect rect = new Rect();
                this.child.getGlobalVisibleRect(rect);
                if (XPopupUtils.isInRect(event.getX(), event.getY(), rect)) break;
                float distance = (float)Math.sqrt(Math.pow(event.getX() - this.touchX, 2.0) + Math.pow(event.getY() - this.touchY, 2.0));
                long duration = System.currentTimeMillis() - this.downTime;
                if (!(distance < (float)ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop()) || duration >= 350L) break;
                this.performClick();
            }
        }
        return true;
    }

    private void finishScroll() {
        int threshold = this.isScrollUp ? (this.maxY - this.minY) / 3 : (this.maxY - this.minY) * 2 / 3;
        int dy = (this.getScrollY() > threshold ? this.maxY : this.minY) - this.getScrollY();
        this.scroller.startScroll(this.getScrollX(), this.getScrollY(), 0, dy, 400);
        this.invalidate();
    }

    public void scrollTo(int x, int y) {
        if (y > this.maxY) {
            y = this.maxY;
        }
        if (y < this.minY) {
            y = this.minY;
        }
        float fraction = (float)(y - this.minY) * 1.0f / (float)(this.maxY - this.minY);
        this.setBackgroundColor(this.bgAnimator.calculateBgColor(fraction));
        if (fraction == 0.0f && this.listener != null) {
            this.listener.onClose();
        }
        this.isScrollUp = y > this.getScrollY();
        super.scrollTo(x, y);
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.scroller.computeScrollOffset()) {
            this.scrollTo(this.scroller.getCurrX(), this.scroller.getCurrY());
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.isScrollUp = false;
    }

    public void open() {
        this.scroller.startScroll(this.getScrollX(), this.getScrollY(), 0, this.maxY - this.getScrollY(), 500);
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    public void close() {
        this.scroller.startScroll(this.getScrollX(), this.getScrollY(), 0, this.minY - this.getScrollY(), 600);
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        return nestedScrollAxes == 2;
    }

    public void onNestedScrollAccepted(View child, View target, int nestedScrollAxes) {
    }

    public void onStopNestedScroll(View target) {
        this.finishScroll();
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        this.scrollTo(this.getScrollX(), this.getScrollY() + dyUnconsumed);
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        if (dy > 0) {
            int newY = this.getScrollY() + dy;
            if (newY < this.maxY) {
                consumed[1] = dy;
            }
            this.scrollTo(this.getScrollX(), newY);
        }
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        return false;
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        return false;
    }

    public int getNestedScrollAxes() {
        return 2;
    }

    public void setOnCloseListener(OnCloseListener listener) {
        this.listener = listener;
    }

    public static interface OnCloseListener {
        public void onClose();
    }
}

