/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.animator;

import android.animation.TimeInterpolator;
import android.support.v4.view.animation.FastOutSlowInInterpolator;
import android.view.View;
import com.lxj.xpopup.animator.PopupAnimator;
import com.lxj.xpopup.enums.PopupAnimation;
import com.lxj.xpopup.util.Utils;

public class TranslateAlphaAnimator
extends PopupAnimator {
    private float startTranslationX;
    private float startTranslationY;
    private float defTranslationX;
    private float defTranslationY;

    public TranslateAlphaAnimator(View target, PopupAnimation popupAnimation) {
        super(target, popupAnimation);
    }

    @Override
    public void initAnimator() {
        this.defTranslationX = this.targetView.getTranslationX();
        this.defTranslationY = this.targetView.getTranslationY();
        this.targetView.setAlpha(0.0f);
        this.applyTranslation();
        this.startTranslationX = this.targetView.getTranslationX();
        this.startTranslationY = this.targetView.getTranslationY();
    }

    private void applyTranslation() {
        int halfWidthOffset = Utils.getWindowWidth(this.targetView.getContext()) / 2 - this.targetView.getMeasuredWidth() / 2;
        int halfHeightOffset = Utils.getWindowHeight(this.targetView.getContext()) / 2 - this.targetView.getMeasuredHeight() / 2;
        switch (this.popupAnimation) {
            case TranslateAlphaFromLeft: {
                this.targetView.setTranslationX((float)(-this.targetView.getMeasuredWidth()));
                break;
            }
            case TranslateAlphaFromTop: {
                this.targetView.setTranslationY((float)(-this.targetView.getMeasuredHeight()));
                break;
            }
            case TranslateAlphaFromRight: {
                this.targetView.setTranslationX((float)this.targetView.getMeasuredWidth());
                break;
            }
            case TranslateAlphaFromBottom: {
                this.targetView.setTranslationY((float)this.targetView.getMeasuredHeight());
            }
        }
    }

    @Override
    public void animateShow() {
        this.targetView.animate().translationX(this.defTranslationX).translationY(this.defTranslationY).alpha(1.0f).setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator()).setDuration((long)this.animateDuration).start();
    }

    @Override
    public void animateDismiss() {
        this.targetView.animate().translationX(this.startTranslationX).translationY(this.startTranslationY).alpha(0.0f).setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator()).setDuration((long)this.animateDuration).start();
    }
}

