/*
 * Decompiled with CFR 0.152.
 */
package com.github.library.bubbleview;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;

public class BubbleDrawable
extends Drawable {
    private RectF mRect;
    private Path mPath = new Path();
    private BitmapShader mBitmapShader;
    private Paint mPaint = new Paint(1);
    private float mArrowWidth;
    private float mAngle;
    private float mArrowHeight;
    private float mArrowPosition;
    private int bubbleColor;
    private Bitmap bubbleBitmap;
    private ArrowLocation mArrowLocation;
    private BubbleType bubbleType;
    private boolean mArrowCenter;

    private BubbleDrawable(Builder builder) {
        this.mRect = builder.mRect;
        this.mAngle = builder.mAngle;
        this.mArrowHeight = builder.mArrowHeight;
        this.mArrowWidth = builder.mArrowWidth;
        this.mArrowPosition = builder.mArrowPosition;
        this.bubbleColor = builder.bubbleColor;
        this.bubbleBitmap = builder.bubbleBitmap;
        this.mArrowLocation = builder.mArrowLocation;
        this.bubbleType = builder.bubbleType;
        this.mArrowCenter = builder.arrowCenter;
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
    }

    public void draw(Canvas canvas) {
        this.setUp(canvas);
    }

    public int getOpacity() {
        return -3;
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    private void setUpPath(ArrowLocation mArrowLocation, Path path) {
        switch (mArrowLocation) {
            case LEFT: {
                this.setUpLeftPath(this.mRect, path);
                break;
            }
            case RIGHT: {
                this.setUpRightPath(this.mRect, path);
                break;
            }
            case TOP: {
                this.setUpTopPath(this.mRect, path);
                break;
            }
            case BOTTOM: {
                this.setUpBottomPath(this.mRect, path);
            }
        }
    }

    private void setUp(Canvas canvas) {
        switch (this.bubbleType) {
            case COLOR: {
                this.mPaint.setColor(this.bubbleColor);
                break;
            }
            case BITMAP: {
                if (this.bubbleBitmap == null) {
                    return;
                }
                if (this.mBitmapShader == null) {
                    this.mBitmapShader = new BitmapShader(this.bubbleBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
                }
                this.mPaint.setShader((Shader)this.mBitmapShader);
                this.setUpShaderMatrix();
            }
        }
        this.setUpPath(this.mArrowLocation, this.mPath);
        canvas.drawPath(this.mPath, this.mPaint);
    }

    private void setUpLeftPath(RectF rect, Path path) {
        if (this.mArrowCenter) {
            this.mArrowPosition = (rect.bottom - rect.top) / 2.0f - this.mArrowWidth / 2.0f;
        }
        path.moveTo(this.mArrowWidth + rect.left + this.mAngle, rect.top);
        path.lineTo(rect.width() - this.mAngle, rect.top);
        path.arcTo(new RectF(rect.right - this.mAngle, rect.top, rect.right, this.mAngle + rect.top), 270.0f, 90.0f);
        path.lineTo(rect.right, rect.bottom - this.mAngle);
        path.arcTo(new RectF(rect.right - this.mAngle, rect.bottom - this.mAngle, rect.right, rect.bottom), 0.0f, 90.0f);
        path.lineTo(rect.left + this.mArrowWidth + this.mAngle, rect.bottom);
        path.arcTo(new RectF(rect.left + this.mArrowWidth, rect.bottom - this.mAngle, this.mAngle + rect.left + this.mArrowWidth, rect.bottom), 90.0f, 90.0f);
        path.lineTo(rect.left + this.mArrowWidth, this.mArrowHeight + this.mArrowPosition);
        path.lineTo(rect.left, this.mArrowPosition + this.mArrowHeight / 2.0f);
        path.lineTo(rect.left + this.mArrowWidth, this.mArrowPosition);
        path.lineTo(rect.left + this.mArrowWidth, rect.top + this.mAngle);
        path.arcTo(new RectF(rect.left + this.mArrowWidth, rect.top, this.mAngle + rect.left + this.mArrowWidth, this.mAngle + rect.top), 180.0f, 90.0f);
        path.close();
    }

    private void setUpTopPath(RectF rect, Path path) {
        if (this.mArrowCenter) {
            this.mArrowPosition = (rect.right - rect.left) / 2.0f - this.mArrowWidth / 2.0f;
        }
        path.moveTo(rect.left + Math.min(this.mArrowPosition, this.mAngle), rect.top + this.mArrowHeight);
        path.lineTo(rect.left + this.mArrowPosition, rect.top + this.mArrowHeight);
        path.lineTo(rect.left + this.mArrowWidth / 2.0f + this.mArrowPosition, rect.top);
        path.lineTo(rect.left + this.mArrowWidth + this.mArrowPosition, rect.top + this.mArrowHeight);
        path.lineTo(rect.right - this.mAngle, rect.top + this.mArrowHeight);
        path.arcTo(new RectF(rect.right - this.mAngle, rect.top + this.mArrowHeight, rect.right, this.mAngle + rect.top + this.mArrowHeight), 270.0f, 90.0f);
        path.lineTo(rect.right, rect.bottom - this.mAngle);
        path.arcTo(new RectF(rect.right - this.mAngle, rect.bottom - this.mAngle, rect.right, rect.bottom), 0.0f, 90.0f);
        path.lineTo(rect.left + this.mAngle, rect.bottom);
        path.arcTo(new RectF(rect.left, rect.bottom - this.mAngle, this.mAngle + rect.left, rect.bottom), 90.0f, 90.0f);
        path.lineTo(rect.left, rect.top + this.mArrowHeight + this.mAngle);
        path.arcTo(new RectF(rect.left, rect.top + this.mArrowHeight, this.mAngle + rect.left, this.mAngle + rect.top + this.mArrowHeight), 180.0f, 90.0f);
        path.close();
    }

    private void setUpRightPath(RectF rect, Path path) {
        if (this.mArrowCenter) {
            this.mArrowPosition = (rect.bottom - rect.top) / 2.0f - this.mArrowWidth / 2.0f;
        }
        path.moveTo(rect.left + this.mAngle, rect.top);
        path.lineTo(rect.width() - this.mAngle - this.mArrowWidth, rect.top);
        path.arcTo(new RectF(rect.right - this.mAngle - this.mArrowWidth, rect.top, rect.right - this.mArrowWidth, this.mAngle + rect.top), 270.0f, 90.0f);
        path.lineTo(rect.right - this.mArrowWidth, this.mArrowPosition);
        path.lineTo(rect.right, this.mArrowPosition + this.mArrowHeight / 2.0f);
        path.lineTo(rect.right - this.mArrowWidth, this.mArrowPosition + this.mArrowHeight);
        path.lineTo(rect.right - this.mArrowWidth, rect.bottom - this.mAngle);
        path.arcTo(new RectF(rect.right - this.mAngle - this.mArrowWidth, rect.bottom - this.mAngle, rect.right - this.mArrowWidth, rect.bottom), 0.0f, 90.0f);
        path.lineTo(rect.left + this.mArrowWidth, rect.bottom);
        path.arcTo(new RectF(rect.left, rect.bottom - this.mAngle, this.mAngle + rect.left, rect.bottom), 90.0f, 90.0f);
        path.arcTo(new RectF(rect.left, rect.top, this.mAngle + rect.left, this.mAngle + rect.top), 180.0f, 90.0f);
        path.close();
    }

    private void setUpBottomPath(RectF rect, Path path) {
        if (this.mArrowCenter) {
            this.mArrowPosition = (rect.right - rect.left) / 2.0f - this.mArrowWidth / 2.0f;
        }
        path.moveTo(rect.left + this.mAngle, rect.top);
        path.lineTo(rect.width() - this.mAngle, rect.top);
        path.arcTo(new RectF(rect.right - this.mAngle, rect.top, rect.right, this.mAngle + rect.top), 270.0f, 90.0f);
        path.lineTo(rect.right, rect.bottom - this.mArrowHeight - this.mAngle);
        path.arcTo(new RectF(rect.right - this.mAngle, rect.bottom - this.mAngle - this.mArrowHeight, rect.right, rect.bottom - this.mArrowHeight), 0.0f, 90.0f);
        path.lineTo(rect.left + this.mArrowWidth + this.mArrowPosition, rect.bottom - this.mArrowHeight);
        path.lineTo(rect.left + this.mArrowPosition + this.mArrowWidth / 2.0f, rect.bottom);
        path.lineTo(rect.left + this.mArrowPosition, rect.bottom - this.mArrowHeight);
        path.lineTo(rect.left + Math.min(this.mAngle, this.mArrowPosition), rect.bottom - this.mArrowHeight);
        path.arcTo(new RectF(rect.left, rect.bottom - this.mAngle - this.mArrowHeight, this.mAngle + rect.left, rect.bottom - this.mArrowHeight), 90.0f, 90.0f);
        path.lineTo(rect.left, rect.top + this.mAngle);
        path.arcTo(new RectF(rect.left, rect.top, this.mAngle + rect.left, this.mAngle + rect.top), 180.0f, 90.0f);
        path.close();
    }

    private void setUpShaderMatrix() {
        Matrix mShaderMatrix = new Matrix();
        mShaderMatrix.set(null);
        int mBitmapWidth = this.bubbleBitmap.getWidth();
        int mBitmapHeight = this.bubbleBitmap.getHeight();
        float scaleX = (float)this.getIntrinsicWidth() / (float)mBitmapWidth;
        float scaleY = (float)this.getIntrinsicHeight() / (float)mBitmapHeight;
        float scale = Math.min(scaleX, scaleY);
        mShaderMatrix.postScale(scale, scale);
        mShaderMatrix.postTranslate(this.mRect.left, this.mRect.top);
        this.mBitmapShader.setLocalMatrix(mShaderMatrix);
    }

    public int getIntrinsicWidth() {
        return (int)this.mRect.width();
    }

    public int getIntrinsicHeight() {
        return (int)this.mRect.height();
    }

    public static enum BubbleType {
        COLOR,
        BITMAP;

    }

    public static enum ArrowLocation {
        LEFT(0),
        RIGHT(1),
        TOP(2),
        BOTTOM(3);

        private int mValue;

        private ArrowLocation(int value) {
            this.mValue = value;
        }

        public static ArrowLocation mapIntToValue(int stateInt) {
            for (ArrowLocation value : ArrowLocation.values()) {
                if (stateInt != value.getIntValue()) continue;
                return value;
            }
            return ArrowLocation.getDefault();
        }

        public static ArrowLocation getDefault() {
            return LEFT;
        }

        public int getIntValue() {
            return this.mValue;
        }
    }

    public static class Builder {
        public static float DEFAULT_ARROW_WITH = 25.0f;
        public static float DEFAULT_ARROW_HEIGHT = 25.0f;
        public static float DEFAULT_ANGLE = 20.0f;
        public static float DEFAULT_ARROW_POSITION = 50.0f;
        public static int DEFAULT_BUBBLE_COLOR = -65536;
        private RectF mRect;
        private float mArrowWidth = DEFAULT_ARROW_WITH;
        private float mAngle = DEFAULT_ANGLE;
        private float mArrowHeight = DEFAULT_ARROW_HEIGHT;
        private float mArrowPosition = DEFAULT_ARROW_POSITION;
        private int bubbleColor = DEFAULT_BUBBLE_COLOR;
        private Bitmap bubbleBitmap;
        private BubbleType bubbleType = BubbleType.COLOR;
        private ArrowLocation mArrowLocation = ArrowLocation.LEFT;
        private boolean arrowCenter;

        public Builder rect(RectF rect) {
            this.mRect = rect;
            return this;
        }

        public Builder arrowWidth(float mArrowWidth) {
            this.mArrowWidth = mArrowWidth;
            return this;
        }

        public Builder angle(float mAngle) {
            this.mAngle = mAngle * 2.0f;
            return this;
        }

        public Builder arrowHeight(float mArrowHeight) {
            this.mArrowHeight = mArrowHeight;
            return this;
        }

        public Builder arrowPosition(float mArrowPosition) {
            this.mArrowPosition = mArrowPosition;
            return this;
        }

        public Builder bubbleColor(int bubbleColor) {
            this.bubbleColor = bubbleColor;
            this.bubbleType(BubbleType.COLOR);
            return this;
        }

        public Builder bubbleBitmap(Bitmap bubbleBitmap) {
            this.bubbleBitmap = bubbleBitmap;
            this.bubbleType(BubbleType.BITMAP);
            return this;
        }

        public Builder arrowLocation(ArrowLocation arrowLocation) {
            this.mArrowLocation = arrowLocation;
            return this;
        }

        public Builder bubbleType(BubbleType bubbleType) {
            this.bubbleType = bubbleType;
            return this;
        }

        public Builder arrowCenter(boolean arrowCenter) {
            this.arrowCenter = arrowCenter;
            return this;
        }

        public BubbleDrawable build() {
            if (this.mRect == null) {
                throw new IllegalArgumentException("BubbleDrawable Rect can not be null");
            }
            return new BubbleDrawable(this);
        }
    }
}

