/*
 * Decompiled with CFR 0.152.
 */
package net.nightwhistler.htmlspanner.handlers;

import android.text.SpannableStringBuilder;
import net.nightwhistler.htmlspanner.FontFamily;
import net.nightwhistler.htmlspanner.SpanStack;
import net.nightwhistler.htmlspanner.css.CSSCompiler;
import net.nightwhistler.htmlspanner.handlers.StyledTextHandler;
import net.nightwhistler.htmlspanner.style.Style;
import org.htmlcleaner.TagNode;

public class FontHandler
extends StyledTextHandler {
    public FontHandler() {
        super(new Style());
    }

    @Override
    public void handleTagNode(TagNode node, SpannableStringBuilder builder, int start, int end, Style style, SpanStack spanStack) {
        if (this.getSpanner().isAllowStyling()) {
            CSSCompiler.StyleUpdater updater;
            String face = node.getAttributeByName("face");
            String size = node.getAttributeByName("size");
            String color = node.getAttributeByName("color");
            FontFamily family = this.getSpanner().getFont(face);
            style = style.setFontFamily(family);
            if (size != null && (updater = CSSCompiler.getStyleUpdater("font-size", size)) != null) {
                style = updater.updateStyle(style, this.getSpanner());
            }
            if (color != null && this.getSpanner().isUseColoursFromStyle() && (updater = CSSCompiler.getStyleUpdater("color", color)) != null) {
                style = updater.updateStyle(style, this.getSpanner());
            }
        }
        super.handleTagNode(node, builder, start, end, style, spanStack);
    }
}

