/*
 * Decompiled with CFR 0.152.
 */
package net.nightwhistler.htmlspanner.spans;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.style.LineBackgroundSpan;
import android.util.Log;
import net.nightwhistler.htmlspanner.style.Style;
import net.nightwhistler.htmlspanner.style.StyleValue;

public class BorderSpan
implements LineBackgroundSpan {
    private int start;
    private int end;
    private Style style;
    private boolean usecolour;

    public BorderSpan(Style style, int start, int end, boolean usecolour) {
        this.start = start;
        this.end = end;
        this.style = style;
        this.usecolour = usecolour;
    }

    public void drawBackground(Canvas c, Paint p, int left, int right, int top, int baseline, int bottom, CharSequence text, int start, int end, int lnum) {
        int baseMargin = 0;
        if (this.style.getMarginLeft() != null) {
            StyleValue styleValue = this.style.getMarginLeft();
            if (styleValue.getUnit() == StyleValue.Unit.PX) {
                if (styleValue.getIntValue() > 0) {
                    baseMargin = styleValue.getIntValue();
                }
            } else if (styleValue.getFloatValue() > 0.0f) {
                baseMargin = (int)(styleValue.getFloatValue() * 10.0f);
            }
            --baseMargin;
        }
        if (baseMargin > 0) {
            left += baseMargin;
        }
        int originalColor = p.getColor();
        float originalStrokeWidth = p.getStrokeWidth();
        if (this.usecolour && this.style.getBackgroundColor() != null) {
            p.setColor(this.style.getBackgroundColor().intValue());
            p.setStyle(Paint.Style.FILL);
            c.drawRect((float)left, (float)top, (float)right, (float)bottom, p);
        }
        if (this.usecolour && this.style.getBorderColor() != null) {
            p.setColor(this.style.getBorderColor().intValue());
        }
        int strokeWidth = this.style.getBorderWidth() != null && this.style.getBorderWidth().getUnit() == StyleValue.Unit.PX ? this.style.getBorderWidth().getIntValue() : 1;
        p.setStrokeWidth((float)strokeWidth);
        right -= strokeWidth;
        p.setStyle(Paint.Style.STROKE);
        if (start <= this.start) {
            Log.d((String)"BorderSpan", (String)"Drawing first line");
            c.drawLine((float)left, (float)top, (float)right, (float)top, p);
        }
        if (end >= this.end) {
            Log.d((String)"BorderSpan", (String)"Drawing last line");
            c.drawLine((float)left, (float)bottom, (float)right, (float)bottom, p);
        }
        c.drawLine((float)left, (float)top, (float)left, (float)bottom, p);
        c.drawLine((float)right, (float)top, (float)right, (float)bottom, p);
        p.setColor(originalColor);
        p.setStrokeWidth(originalStrokeWidth);
    }
}

