/*
 * Decompiled with CFR 0.152.
 */
package net.nightwhistler.htmlspanner.style;

import android.util.Log;

public class StyleValue {
    private Integer intValue;
    private Float floatValue;
    private Unit unit;

    public static StyleValue parse(String value) {
        if (value.equals("0")) {
            return new StyleValue(0.0f, Unit.EM);
        }
        if (value.endsWith("px")) {
            try {
                Integer intValue = Integer.parseInt(value.substring(0, value.length() - 2));
                return new StyleValue(intValue);
            }
            catch (NumberFormatException nfe) {
                Log.e((String)"StyleValue", (String)("Can't parse value: " + value));
                return null;
            }
        }
        if (value.endsWith("%")) {
            Log.d((String)"StyleValue", (String)("translating percentage " + value));
            try {
                int percentage = Integer.parseInt(value.substring(0, value.length() - 1));
                float floatValue = (float)percentage / 100.0f;
                return new StyleValue(floatValue, Unit.PERCENTAGE);
            }
            catch (NumberFormatException nfe) {
                Log.e((String)"StyleValue", (String)("Can't parse font-size: " + value));
                return null;
            }
        }
        if (value.endsWith("em")) {
            try {
                Float number = Float.valueOf(Float.parseFloat(value.substring(0, value.length() - 2)));
                return new StyleValue(number.floatValue(), Unit.EM);
            }
            catch (NumberFormatException nfe) {
                Log.e((String)"CSSCompiler", (String)("Can't parse value: " + value));
                return null;
            }
        }
        return null;
    }

    public StyleValue(int intValue) {
        this.unit = Unit.PX;
        this.intValue = intValue;
    }

    public StyleValue(float floatValue, Unit unit) {
        this.floatValue = Float.valueOf(floatValue);
        this.unit = unit;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public float getFloatValue() {
        return this.floatValue.floatValue();
    }

    public Unit getUnit() {
        return this.unit;
    }

    public String toString() {
        if (this.intValue != null) {
            return "" + this.intValue + (Object)((Object)this.unit);
        }
        return "" + this.floatValue + (Object)((Object)this.unit);
    }

    public static enum Unit {
        PX,
        EM,
        PERCENTAGE;

    }
}

