/*
 * Decompiled with CFR 0.152.
 */
package net.nightwhistler.htmlspanner.handlers;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.Layout;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.style.AlignmentSpan;
import android.text.style.ImageSpan;
import java.util.ArrayList;
import java.util.List;
import net.nightwhistler.htmlspanner.TagNodeHandler;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.TagNode;

public class TableHandler
extends TagNodeHandler {
    private int tableWidth = 400;
    private Typeface typeFace = Typeface.DEFAULT;
    private float textSize = 16.0f;
    private int textColor = -16777216;
    private static final int PADDING = 5;

    public void setTableWidth(int tableWidth) {
        this.tableWidth = tableWidth;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public void setTextSize(float textSize) {
        this.textSize = textSize;
    }

    public void setTypeFace(Typeface typeFace) {
        this.typeFace = typeFace;
    }

    @Override
    public boolean rendersContent() {
        return true;
    }

    private void readNode(Object node, Table table) {
        if (node instanceof ContentNode) {
            return;
        }
        TagNode tagNode = (TagNode)node;
        if (tagNode.getName().equals("td")) {
            Spannable result = this.getSpanner().fromTagNode(tagNode);
            table.addCell((Spanned)result);
            return;
        }
        if (tagNode.getName().equals("tr")) {
            table.addRow();
        }
        for (Object child : tagNode.getChildren()) {
            this.readNode(child, table);
        }
    }

    private Table getTable(TagNode node) {
        Table result = new Table();
        this.readNode(node, result);
        return result;
    }

    private TextPaint getTextPaint() {
        TextPaint textPaint = new TextPaint();
        textPaint.setColor(this.textColor);
        textPaint.setAntiAlias(true);
        textPaint.setTextSize(this.textSize);
        textPaint.setTypeface(this.typeFace);
        return textPaint;
    }

    private int calculateRowHeight(List<Spanned> row) {
        if (row.size() == 0) {
            return 0;
        }
        TextPaint textPaint = this.getTextPaint();
        int columnWidth = this.tableWidth / row.size();
        int rowHeight = 0;
        for (Spanned cell : row) {
            StaticLayout layout = new StaticLayout((CharSequence)cell, textPaint, columnWidth - 10, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
            if (layout.getHeight() <= rowHeight) continue;
            rowHeight = layout.getHeight();
        }
        return rowHeight;
    }

    @Override
    public void handleTagNode(TagNode node, SpannableStringBuilder builder, int start, int end) {
        Table table = this.getTable(node);
        for (int i = 0; i < table.getRows().size(); ++i) {
            List<Spanned> row = table.getRows().get(i);
            builder.append((CharSequence)"\ufffc");
            TableRowDrawable drawable = new TableRowDrawable(row);
            drawable.setBounds(0, 0, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight());
            builder.setSpan((Object)new ImageSpan((Drawable)drawable), start + i, builder.length(), 33);
        }
        builder.append((CharSequence)"\ufffc");
        TableRowDrawable drawable = new TableRowDrawable(new ArrayList<Spanned>());
        drawable.setBounds(0, 0, this.tableWidth, 1);
        builder.setSpan((Object)new ImageSpan((Drawable)drawable), builder.length() - 1, builder.length(), 33);
        builder.setSpan((Object)new AlignmentSpan(){

            public Layout.Alignment getAlignment() {
                return Layout.Alignment.ALIGN_CENTER;
            }
        }, start, builder.length(), 33);
    }

    private class Table {
        private List<List<Spanned>> content = new ArrayList<List<Spanned>>();

        private Table() {
        }

        public void addRow() {
            this.content.add(new ArrayList());
        }

        public List<Spanned> getBottomRow() {
            return this.content.get(this.content.size() - 1);
        }

        public List<List<Spanned>> getRows() {
            return this.content;
        }

        public void addCell(Spanned text) {
            if (this.content.isEmpty()) {
                throw new IllegalStateException("No rows added yet");
            }
            this.getBottomRow().add(text);
        }
    }

    private class TableRowDrawable
    extends Drawable {
        private List<Spanned> tableRow;
        private int rowHeight;

        public TableRowDrawable(List<Spanned> tableRow) {
            this.tableRow = tableRow;
            this.rowHeight = TableHandler.this.calculateRowHeight(tableRow);
        }

        public void draw(Canvas canvas) {
            Paint paint = new Paint();
            paint.setColor(TableHandler.this.textColor);
            paint.setStyle(Paint.Style.STROKE);
            int numberOfColumns = this.tableRow.size();
            if (numberOfColumns == 0) {
                return;
            }
            int columnWidth = TableHandler.this.tableWidth / numberOfColumns;
            int offset = 0;
            for (int i = 0; i < numberOfColumns; ++i) {
                offset = i * columnWidth;
                canvas.drawRect((float)offset, 0.0f, (float)(offset + columnWidth), (float)this.rowHeight, paint);
                StaticLayout layout = new StaticLayout((CharSequence)this.tableRow.get(i), TableHandler.this.getTextPaint(), columnWidth - 10, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
                canvas.translate((float)(offset + 5), 0.0f);
                layout.draw(canvas);
                canvas.translate((float)(-1 * (offset + 5)), 0.0f);
            }
        }

        public int getIntrinsicHeight() {
            return this.rowHeight;
        }

        public int getIntrinsicWidth() {
            return TableHandler.this.tableWidth;
        }

        public int getOpacity() {
            return -1;
        }

        public void setAlpha(int alpha) {
        }

        public void setColorFilter(ColorFilter cf) {
        }
    }
}

