/*
 * Decompiled with CFR 0.152.
 */
package org.jblas;

public class ComplexFloat {
    private float r;
    private float i;
    public static final ComplexFloat UNIT = new ComplexFloat(1.0f, 0.0f);
    public static final ComplexFloat I = new ComplexFloat(0.0f, 1.0f);
    public static final ComplexFloat NEG_UNIT = new ComplexFloat(-1.0f, 0.0f);
    public static final ComplexFloat NEG_I = new ComplexFloat(0.0f, -1.0f);
    public static final ComplexFloat ZERO = new ComplexFloat(0.0f);

    public ComplexFloat(float real, float imag) {
        this.r = real;
        this.i = imag;
    }

    public ComplexFloat(float real) {
        this(real, 0.0f);
    }

    public String toString() {
        if (this.i >= 0.0f) {
            return this.r + " + " + this.i + "i";
        }
        return this.r + " - " + -this.i + "i";
    }

    public ComplexFloat set(float real, float imag) {
        this.r = real;
        this.i = imag;
        return this;
    }

    public float real() {
        return this.r;
    }

    public float imag() {
        return this.i;
    }

    public ComplexFloat dup() {
        return new ComplexFloat(this.r, this.i);
    }

    public ComplexFloat copy(ComplexFloat other) {
        this.r = other.r;
        this.i = other.i;
        return this;
    }

    public ComplexFloat addi(ComplexFloat c, ComplexFloat result) {
        if (this == result) {
            this.r += c.r;
            this.i += c.i;
        } else {
            result.r = this.r + c.r;
            result.i = this.i + c.i;
        }
        return result;
    }

    public ComplexFloat addi(ComplexFloat c) {
        return this.addi(c, this);
    }

    public ComplexFloat add(ComplexFloat c) {
        return this.dup().addi(c);
    }

    public ComplexFloat addi(float a, ComplexFloat result) {
        if (this == result) {
            this.r += a;
        } else {
            result.r = this.r + a;
            result.i = this.i;
        }
        return result;
    }

    public ComplexFloat addi(float c) {
        return this.addi(c, this);
    }

    public ComplexFloat add(float c) {
        return this.dup().addi(c);
    }

    public ComplexFloat subi(ComplexFloat c, ComplexFloat result) {
        if (this == result) {
            this.r -= c.r;
            this.i -= c.i;
        } else {
            result.r = this.r - c.r;
            result.i = this.i - c.i;
        }
        return this;
    }

    public ComplexFloat subi(ComplexFloat c) {
        return this.subi(c, this);
    }

    public ComplexFloat sub(ComplexFloat c) {
        return this.dup().subi(c);
    }

    public ComplexFloat subi(float a, ComplexFloat result) {
        if (this == result) {
            this.r -= a;
        } else {
            result.r = this.r - a;
            result.i = this.i;
        }
        return result;
    }

    public ComplexFloat subi(float a) {
        return this.subi(a, this);
    }

    public ComplexFloat sub(float r) {
        return this.dup().subi(r);
    }

    public ComplexFloat muli(ComplexFloat c, ComplexFloat result) {
        float newR = this.r * c.r - this.i * c.i;
        float newI = this.r * c.i + this.i * c.r;
        result.r = newR;
        result.i = newI;
        return result;
    }

    public ComplexFloat muli(ComplexFloat c) {
        return this.muli(c, this);
    }

    public ComplexFloat mul(ComplexFloat c) {
        return this.dup().muli(c);
    }

    public ComplexFloat mul(float v) {
        return this.dup().muli(v);
    }

    public ComplexFloat muli(float v, ComplexFloat result) {
        if (this == result) {
            this.r *= v;
            this.i *= v;
        } else {
            result.r = this.r * v;
            result.i = this.i * v;
        }
        return this;
    }

    public ComplexFloat muli(float v) {
        return this.muli(v, this);
    }

    public ComplexFloat div(ComplexFloat c) {
        return this.dup().divi(c);
    }

    public ComplexFloat divi(ComplexFloat c, ComplexFloat result) {
        float d = c.r * c.r + c.i * c.i;
        float newR = (this.r * c.r + this.i * c.i) / d;
        float newI = (this.i * c.r - this.r * c.i) / d;
        result.r = newR;
        result.i = newI;
        return result;
    }

    public ComplexFloat divi(ComplexFloat c) {
        return this.divi(c, this);
    }

    public ComplexFloat divi(float v, ComplexFloat result) {
        if (this == result) {
            this.r /= v;
            this.i /= v;
        } else {
            result.r = this.r / v;
            result.i = this.i / v;
        }
        return this;
    }

    public ComplexFloat divi(float v) {
        return this.divi(v, this);
    }

    public ComplexFloat div(float v) {
        return this.dup().divi(v);
    }

    public float abs() {
        return (float)Math.sqrt(this.r * this.r + this.i * this.i);
    }

    public float arg() {
        return (float)Math.acos(this.r / this.abs());
    }

    public ComplexFloat invi() {
        float d = this.r * this.r + this.i * this.i;
        this.r /= d;
        this.i = -this.i / d;
        return this;
    }

    public ComplexFloat inv() {
        return this.dup().invi();
    }

    public ComplexFloat neg() {
        return this.dup().negi();
    }

    public ComplexFloat negi() {
        this.r = -this.r;
        this.i = -this.i;
        return this;
    }

    public ComplexFloat conji() {
        this.i = -this.i;
        return this;
    }

    public ComplexFloat conj() {
        return this.dup().conji();
    }

    public ComplexFloat sqrt() {
        float a = this.abs();
        float s2 = (float)Math.sqrt(2.0);
        float p = (float)Math.sqrt(a + this.r) / s2;
        float q = (float)Math.sqrt(a - this.r) / s2 * Math.signum(this.i);
        return new ComplexFloat(p, q);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ComplexFloat)) {
            return false;
        }
        ComplexFloat c = (ComplexFloat)o;
        return this.eq(c);
    }

    public boolean eq(ComplexFloat c) {
        return Math.abs(this.r - c.r) + Math.abs(this.i - c.i) < 1.0E-6f;
    }

    public boolean ne(ComplexFloat c) {
        return !this.eq(c);
    }

    public boolean isZero() {
        return this.r == 0.0f && this.i == 0.0f;
    }

    public boolean isReal() {
        return this.i == 0.0f;
    }

    public boolean isImag() {
        return this.r == 0.0f;
    }
}

