/*
 * Decompiled with CFR 0.152.
 */
package lecho.lib.hellocharts.model;

import java.util.Arrays;

public class AxisValue {
    private float value;
    private char[] label;

    public AxisValue(float value) {
        this.setValue(value);
    }

    @Deprecated
    public AxisValue(float value, char[] label) {
        this.value = value;
        this.label = label;
    }

    public AxisValue(AxisValue axisValue) {
        this.value = axisValue.value;
        this.label = axisValue.label;
    }

    public float getValue() {
        return this.value;
    }

    public AxisValue setValue(float value) {
        this.value = value;
        return this;
    }

    @Deprecated
    public char[] getLabel() {
        return this.label;
    }

    public AxisValue setLabel(String label) {
        this.label = label.toCharArray();
        return this;
    }

    public char[] getLabelAsChars() {
        return this.label;
    }

    @Deprecated
    public AxisValue setLabel(char[] label) {
        this.label = label;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AxisValue axisValue = (AxisValue)o;
        if (Float.compare(axisValue.value, this.value) != 0) {
            return false;
        }
        return Arrays.equals(this.label, axisValue.label);
    }

    public int hashCode() {
        int result = this.value != 0.0f ? Float.floatToIntBits(this.value) : 0;
        result = 31 * result + (this.label != null ? Arrays.hashCode(this.label) : 0);
        return result;
    }
}

