/*
 * Decompiled with CFR 0.152.
 */
package lecho.lib.hellocharts.animation;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import lecho.lib.hellocharts.animation.ChartAnimationListener;
import lecho.lib.hellocharts.animation.ChartDataAnimator;
import lecho.lib.hellocharts.animation.DummyChartAnimationListener;
import lecho.lib.hellocharts.view.Chart;

@SuppressLint(value={"NewApi"})
public class ChartDataAnimatorV14
implements ChartDataAnimator,
Animator.AnimatorListener,
ValueAnimator.AnimatorUpdateListener {
    private final Chart chart;
    private ValueAnimator animator;
    private ChartAnimationListener animationListener = new DummyChartAnimationListener();

    public ChartDataAnimatorV14(Chart chart) {
        this.chart = chart;
        this.animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.animator.addListener((Animator.AnimatorListener)this);
        this.animator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
    }

    @Override
    public void startAnimation(long duration) {
        if (duration >= 0L) {
            this.animator.setDuration(duration);
        } else {
            this.animator.setDuration(500L);
        }
        this.animator.start();
    }

    @Override
    public void cancelAnimation() {
        this.animator.cancel();
    }

    public void onAnimationUpdate(ValueAnimator animation) {
        this.chart.animationDataUpdate(animation.getAnimatedFraction());
    }

    public void onAnimationCancel(Animator animation) {
    }

    public void onAnimationEnd(Animator animation) {
        this.chart.animationDataFinished();
        this.animationListener.onAnimationFinished();
    }

    public void onAnimationRepeat(Animator animation) {
    }

    public void onAnimationStart(Animator animation) {
        this.animationListener.onAnimationStarted();
    }

    @Override
    public boolean isAnimationStarted() {
        return this.animator.isStarted();
    }

    @Override
    public void setChartAnimationListener(ChartAnimationListener animationListener) {
        this.animationListener = null == animationListener ? new DummyChartAnimationListener() : animationListener;
    }
}

