/*
 * Decompiled with CFR 0.152.
 */
package lecho.lib.hellocharts.model;

public class SelectedValue {
    private int firstIndex;
    private int secondIndex;
    private SelectedValueType type = SelectedValueType.NONE;

    public SelectedValue() {
        this.clear();
    }

    public SelectedValue(int firstIndex, int secondIndex, SelectedValueType type) {
        this.set(firstIndex, secondIndex, type);
    }

    public void set(int firstIndex, int secondIndex, SelectedValueType type) {
        this.firstIndex = firstIndex;
        this.secondIndex = secondIndex;
        this.type = null != type ? type : SelectedValueType.NONE;
    }

    public void set(SelectedValue selectedValue) {
        this.firstIndex = selectedValue.firstIndex;
        this.secondIndex = selectedValue.secondIndex;
        this.type = selectedValue.type;
    }

    public void clear() {
        this.set(Integer.MIN_VALUE, Integer.MIN_VALUE, SelectedValueType.NONE);
    }

    public boolean isSet() {
        return this.firstIndex >= 0 && this.secondIndex >= 0;
    }

    public int getFirstIndex() {
        return this.firstIndex;
    }

    public void setFirstIndex(int firstIndex) {
        this.firstIndex = firstIndex;
    }

    public int getSecondIndex() {
        return this.secondIndex;
    }

    public void setSecondIndex(int secondIndex) {
        this.secondIndex = secondIndex;
    }

    public SelectedValueType getType() {
        return this.type;
    }

    public void setType(SelectedValueType type) {
        this.type = type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.firstIndex;
        result = 31 * result + this.secondIndex;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SelectedValue other = (SelectedValue)obj;
        if (this.firstIndex != other.firstIndex) {
            return false;
        }
        if (this.secondIndex != other.secondIndex) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        return "SelectedValue [firstIndex=" + this.firstIndex + ", secondIndex=" + this.secondIndex + ", type=" + (Object)((Object)this.type) + "]";
    }

    public static enum SelectedValueType {
        NONE,
        LINE,
        COLUMN;

    }
}

