/*
 * Decompiled with CFR 0.152.
 */
package lecho.lib.hellocharts.renderer;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.text.TextUtils;
import lecho.lib.hellocharts.computator.ChartComputator;
import lecho.lib.hellocharts.model.Axis;
import lecho.lib.hellocharts.model.AxisValue;
import lecho.lib.hellocharts.model.Viewport;
import lecho.lib.hellocharts.util.AxisAutoValues;
import lecho.lib.hellocharts.util.ChartUtils;
import lecho.lib.hellocharts.util.FloatUtils;
import lecho.lib.hellocharts.view.Chart;

public class AxesRenderer {
    private static final int DEFAULT_AXIS_MARGIN_DP = 2;
    private static final int TOP = 0;
    private static final int LEFT = 1;
    private static final int RIGHT = 2;
    private static final int BOTTOM = 3;
    private static final char[] labelWidthChars = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'};
    private Chart chart;
    private ChartComputator computator;
    private int axisMargin;
    private float density;
    private float scaledDensity;
    private Paint[] labelPaintTab = new Paint[]{new Paint(), new Paint(), new Paint(), new Paint()};
    private Paint[] namePaintTab = new Paint[]{new Paint(), new Paint(), new Paint(), new Paint()};
    private Paint[] linePaintTab = new Paint[]{new Paint(), new Paint(), new Paint(), new Paint()};
    private float[] nameBaselineTab = new float[4];
    private float[] labelBaselineTab = new float[4];
    private float[] separationLineTab = new float[4];
    private int[] labelWidthTab = new int[4];
    private int[] labelTextAscentTab = new int[4];
    private int[] labelTextDescentTab = new int[4];
    private int[] labelDimensionForMarginsTab = new int[4];
    private int[] labelDimensionForStepsTab = new int[4];
    private int[] tiltedLabelXTranslation = new int[4];
    private int[] tiltedLabelYTranslation = new int[4];
    private Paint.FontMetricsInt[] fontMetricsTab = new Paint.FontMetricsInt[]{new Paint.FontMetricsInt(), new Paint.FontMetricsInt(), new Paint.FontMetricsInt(), new Paint.FontMetricsInt()};
    private char[] labelBuffer = new char[64];
    private int[] valuesToDrawNumTab = new int[4];
    private float[][] rawValuesTab = new float[4][0];
    private float[][] autoValuesToDrawTab = new float[4][0];
    private AxisValue[][] valuesToDrawTab = new AxisValue[4][0];
    private float[][] linesDrawBufferTab = new float[4][0];
    private AxisAutoValues[] autoValuesBufferTab = new AxisAutoValues[]{new AxisAutoValues(), new AxisAutoValues(), new AxisAutoValues(), new AxisAutoValues()};

    public AxesRenderer(Context context, Chart chart) {
        this.chart = chart;
        this.computator = chart.getChartComputator();
        this.density = context.getResources().getDisplayMetrics().density;
        this.scaledDensity = context.getResources().getDisplayMetrics().scaledDensity;
        this.axisMargin = ChartUtils.dp2px(this.density, 2);
        for (int position = 0; position < 4; ++position) {
            this.labelPaintTab[position].setStyle(Paint.Style.FILL);
            this.labelPaintTab[position].setAntiAlias(true);
            this.namePaintTab[position].setStyle(Paint.Style.FILL);
            this.namePaintTab[position].setAntiAlias(true);
            this.linePaintTab[position].setStyle(Paint.Style.STROKE);
            this.linePaintTab[position].setAntiAlias(true);
        }
    }

    public void onChartSizeChanged() {
        this.onChartDataOrSizeChanged();
    }

    public void onChartDataChanged() {
        this.onChartDataOrSizeChanged();
    }

    private void onChartDataOrSizeChanged() {
        this.initAxis(this.chart.getChartData().getAxisXTop(), 0);
        this.initAxis(this.chart.getChartData().getAxisXBottom(), 3);
        this.initAxis(this.chart.getChartData().getAxisYLeft(), 1);
        this.initAxis(this.chart.getChartData().getAxisYRight(), 2);
    }

    public void resetRenderer() {
        this.computator = this.chart.getChartComputator();
    }

    private void initAxis(Axis axis, int position) {
        if (null == axis) {
            return;
        }
        this.initAxisAttributes(axis, position);
        this.initAxisMargin(axis, position);
        this.initAxisMeasurements(axis, position);
    }

    private void initAxisAttributes(Axis axis, int position) {
        this.initAxisPaints(axis, position);
        this.initAxisTextAlignment(axis, position);
        if (axis.hasTiltedLabels()) {
            this.initAxisDimensionForTiltedLabels(position);
            this.intiTiltedLabelsTranslation(axis, position);
        } else {
            this.initAxisDimension(position);
        }
    }

    private void initAxisPaints(Axis axis, int position) {
        Typeface typeface = axis.getTypeface();
        if (null != typeface) {
            this.labelPaintTab[position].setTypeface(typeface);
            this.namePaintTab[position].setTypeface(typeface);
        }
        this.labelPaintTab[position].setColor(axis.getTextColor());
        this.labelPaintTab[position].setTextSize((float)ChartUtils.sp2px(this.scaledDensity, axis.getTextSize()));
        this.labelPaintTab[position].getFontMetricsInt(this.fontMetricsTab[position]);
        this.namePaintTab[position].setColor(axis.getTextColor());
        this.namePaintTab[position].setTextSize((float)ChartUtils.sp2px(this.scaledDensity, axis.getTextSize()));
        this.linePaintTab[position].setColor(axis.getLineColor());
        this.labelTextAscentTab[position] = Math.abs(this.fontMetricsTab[position].ascent);
        this.labelTextDescentTab[position] = Math.abs(this.fontMetricsTab[position].descent);
        this.labelWidthTab[position] = (int)this.labelPaintTab[position].measureText(labelWidthChars, 0, axis.getMaxLabelChars());
    }

    private void initAxisTextAlignment(Axis axis, int position) {
        this.namePaintTab[position].setTextAlign(Paint.Align.CENTER);
        if (0 == position || 3 == position) {
            this.labelPaintTab[position].setTextAlign(Paint.Align.CENTER);
        } else if (1 == position) {
            if (axis.isInside()) {
                this.labelPaintTab[position].setTextAlign(Paint.Align.LEFT);
            } else {
                this.labelPaintTab[position].setTextAlign(Paint.Align.RIGHT);
            }
        } else if (2 == position) {
            if (axis.isInside()) {
                this.labelPaintTab[position].setTextAlign(Paint.Align.RIGHT);
            } else {
                this.labelPaintTab[position].setTextAlign(Paint.Align.LEFT);
            }
        }
    }

    private void initAxisDimensionForTiltedLabels(int position) {
        int pythagoreanFromLabelWidth = (int)Math.sqrt(Math.pow(this.labelWidthTab[position], 2.0) / 2.0);
        int pythagoreanFromAscent = (int)Math.sqrt(Math.pow(this.labelTextAscentTab[position], 2.0) / 2.0);
        this.labelDimensionForMarginsTab[position] = pythagoreanFromAscent + pythagoreanFromLabelWidth;
        this.labelDimensionForStepsTab[position] = Math.round((float)this.labelDimensionForMarginsTab[position] * 0.75f);
    }

    private void initAxisDimension(int position) {
        if (1 == position || 2 == position) {
            this.labelDimensionForMarginsTab[position] = this.labelWidthTab[position];
            this.labelDimensionForStepsTab[position] = this.labelTextAscentTab[position];
        } else if (0 == position || 3 == position) {
            this.labelDimensionForMarginsTab[position] = this.labelTextAscentTab[position] + this.labelTextDescentTab[position];
            this.labelDimensionForStepsTab[position] = this.labelWidthTab[position];
        }
    }

    private void intiTiltedLabelsTranslation(Axis axis, int position) {
        int pythagoreanFromLabelWidth = (int)Math.sqrt(Math.pow(this.labelWidthTab[position], 2.0) / 2.0);
        int pythagoreanFromAscent = (int)Math.sqrt(Math.pow(this.labelTextAscentTab[position], 2.0) / 2.0);
        int dx = 0;
        int dy = 0;
        if (axis.isInside()) {
            if (1 == position) {
                dx = pythagoreanFromAscent;
            } else if (2 == position) {
                dy = -pythagoreanFromLabelWidth / 2;
            } else if (0 == position) {
                dy = pythagoreanFromAscent + pythagoreanFromLabelWidth / 2 - this.labelTextAscentTab[position];
            } else if (3 == position) {
                dy = -pythagoreanFromLabelWidth / 2;
            }
        } else if (1 == position) {
            dy = -pythagoreanFromLabelWidth / 2;
        } else if (2 == position) {
            dx = pythagoreanFromAscent;
        } else if (0 == position) {
            dy = -pythagoreanFromLabelWidth / 2;
        } else if (3 == position) {
            dy = pythagoreanFromAscent + pythagoreanFromLabelWidth / 2 - this.labelTextAscentTab[position];
        }
        this.tiltedLabelXTranslation[position] = dx;
        this.tiltedLabelYTranslation[position] = dy;
    }

    private void initAxisMargin(Axis axis, int position) {
        int margin = 0;
        if (!(axis.isInside() || !axis.isAutoGenerated() && axis.getValues().isEmpty())) {
            margin += this.axisMargin + this.labelDimensionForMarginsTab[position];
        }
        this.insetContentRectWithAxesMargins(margin += this.getAxisNameMargin(axis, position), position);
    }

    private int getAxisNameMargin(Axis axis, int position) {
        int margin = 0;
        if (!TextUtils.isEmpty((CharSequence)axis.getName())) {
            margin += this.labelTextAscentTab[position];
            margin += this.labelTextDescentTab[position];
            margin += this.axisMargin;
        }
        return margin;
    }

    private void insetContentRectWithAxesMargins(int axisMargin, int position) {
        if (1 == position) {
            this.chart.getChartComputator().insetContentRect(axisMargin, 0, 0, 0);
        } else if (2 == position) {
            this.chart.getChartComputator().insetContentRect(0, 0, axisMargin, 0);
        } else if (0 == position) {
            this.chart.getChartComputator().insetContentRect(0, axisMargin, 0, 0);
        } else if (3 == position) {
            this.chart.getChartComputator().insetContentRect(0, 0, 0, axisMargin);
        }
    }

    private void initAxisMeasurements(Axis axis, int position) {
        if (1 == position) {
            if (axis.isInside()) {
                this.labelBaselineTab[position] = this.computator.getContentRectMinusAxesMargins().left + this.axisMargin;
                this.nameBaselineTab[position] = this.computator.getContentRectMinusAxesMargins().left - this.axisMargin - this.labelTextDescentTab[position];
            } else {
                this.labelBaselineTab[position] = this.computator.getContentRectMinusAxesMargins().left - this.axisMargin;
                this.nameBaselineTab[position] = this.labelBaselineTab[position] - (float)this.axisMargin - (float)this.labelTextDescentTab[position] - (float)this.labelDimensionForMarginsTab[position];
            }
            this.separationLineTab[position] = this.computator.getContentRectMinusAllMargins().left;
        } else if (2 == position) {
            if (axis.isInside()) {
                this.labelBaselineTab[position] = this.computator.getContentRectMinusAxesMargins().right - this.axisMargin;
                this.nameBaselineTab[position] = this.computator.getContentRectMinusAxesMargins().right + this.axisMargin + this.labelTextAscentTab[position];
            } else {
                this.labelBaselineTab[position] = this.computator.getContentRectMinusAxesMargins().right + this.axisMargin;
                this.nameBaselineTab[position] = this.labelBaselineTab[position] + (float)this.axisMargin + (float)this.labelTextAscentTab[position] + (float)this.labelDimensionForMarginsTab[position];
            }
            this.separationLineTab[position] = this.computator.getContentRectMinusAllMargins().right;
        } else if (3 == position) {
            if (axis.isInside()) {
                this.labelBaselineTab[position] = this.computator.getContentRectMinusAxesMargins().bottom - this.axisMargin - this.labelTextDescentTab[position];
                this.nameBaselineTab[position] = this.computator.getContentRectMinusAxesMargins().bottom + this.axisMargin + this.labelTextAscentTab[position];
            } else {
                this.labelBaselineTab[position] = this.computator.getContentRectMinusAxesMargins().bottom + this.axisMargin + this.labelTextAscentTab[position];
                this.nameBaselineTab[position] = this.labelBaselineTab[position] + (float)this.axisMargin + (float)this.labelDimensionForMarginsTab[position];
            }
            this.separationLineTab[position] = this.computator.getContentRectMinusAllMargins().bottom;
        } else if (0 == position) {
            if (axis.isInside()) {
                this.labelBaselineTab[position] = this.computator.getContentRectMinusAxesMargins().top + this.axisMargin + this.labelTextAscentTab[position];
                this.nameBaselineTab[position] = this.computator.getContentRectMinusAxesMargins().top - this.axisMargin - this.labelTextDescentTab[position];
            } else {
                this.labelBaselineTab[position] = this.computator.getContentRectMinusAxesMargins().top - this.axisMargin - this.labelTextDescentTab[position];
                this.nameBaselineTab[position] = this.labelBaselineTab[position] - (float)this.axisMargin - (float)this.labelDimensionForMarginsTab[position];
            }
            this.separationLineTab[position] = this.computator.getContentRectMinusAllMargins().top;
        } else {
            throw new IllegalArgumentException("Invalid axis position: " + position);
        }
    }

    public void drawInBackground(Canvas canvas) {
        Axis axis = this.chart.getChartData().getAxisYLeft();
        if (null != axis) {
            this.prepareAxisToDraw(axis, 1);
            this.drawAxisLines(canvas, axis, 1);
        }
        if (null != (axis = this.chart.getChartData().getAxisYRight())) {
            this.prepareAxisToDraw(axis, 2);
            this.drawAxisLines(canvas, axis, 2);
        }
        if (null != (axis = this.chart.getChartData().getAxisXBottom())) {
            this.prepareAxisToDraw(axis, 3);
            this.drawAxisLines(canvas, axis, 3);
        }
        if (null != (axis = this.chart.getChartData().getAxisXTop())) {
            this.prepareAxisToDraw(axis, 0);
            this.drawAxisLines(canvas, axis, 0);
        }
    }

    private void prepareAxisToDraw(Axis axis, int position) {
        if (axis.isAutoGenerated()) {
            this.prepareAutoGeneratedAxis(axis, position);
        } else {
            this.prepareCustomAxis(axis, position);
        }
    }

    public void drawInForeground(Canvas canvas) {
        Axis axis = this.chart.getChartData().getAxisYLeft();
        if (null != axis) {
            this.drawAxisLabelsAndName(canvas, axis, 1);
        }
        if (null != (axis = this.chart.getChartData().getAxisYRight())) {
            this.drawAxisLabelsAndName(canvas, axis, 2);
        }
        if (null != (axis = this.chart.getChartData().getAxisXBottom())) {
            this.drawAxisLabelsAndName(canvas, axis, 3);
        }
        if (null != (axis = this.chart.getChartData().getAxisXTop())) {
            this.drawAxisLabelsAndName(canvas, axis, 0);
        }
    }

    private void prepareCustomAxis(Axis axis, int position) {
        float viewportMax;
        float viewportMin;
        Viewport maxViewport = this.computator.getMaximumViewport();
        Viewport visibleViewport = this.computator.getVisibleViewport();
        Rect contentRect = this.computator.getContentRectMinusAllMargins();
        boolean isAxisVertical = this.isAxisVertical(position);
        float scale = 1.0f;
        if (isAxisVertical) {
            if (maxViewport.height() > 0.0f && visibleViewport.height() > 0.0f) {
                scale = (float)contentRect.height() * (maxViewport.height() / visibleViewport.height());
            }
            viewportMin = visibleViewport.bottom;
            viewportMax = visibleViewport.top;
        } else {
            if (maxViewport.width() > 0.0f && visibleViewport.width() > 0.0f) {
                scale = (float)contentRect.width() * (maxViewport.width() / visibleViewport.width());
            }
            viewportMin = visibleViewport.left;
            viewportMax = visibleViewport.right;
        }
        if (scale == 0.0f) {
            scale = 1.0f;
        }
        int module = (int)Math.max(1.0, Math.ceil((double)(axis.getValues().size() * this.labelDimensionForStepsTab[position]) * 1.5 / (double)scale));
        if (axis.hasLines() && this.linesDrawBufferTab[position].length < axis.getValues().size() * 4) {
            this.linesDrawBufferTab[position] = new float[axis.getValues().size() * 4];
        }
        if (this.rawValuesTab[position].length < axis.getValues().size()) {
            this.rawValuesTab[position] = new float[axis.getValues().size()];
        }
        if (this.valuesToDrawTab[position].length < axis.getValues().size()) {
            this.valuesToDrawTab[position] = new AxisValue[axis.getValues().size()];
        }
        int valueIndex = 0;
        int valueToDrawIndex = 0;
        for (AxisValue axisValue : axis.getValues()) {
            float rawValue;
            float value = axisValue.getValue();
            if (!(value >= viewportMin) || !(value <= viewportMax)) continue;
            if (0 == valueIndex % module && this.checkRawValue(contentRect, rawValue = isAxisVertical ? this.computator.computeRawY(value) : this.computator.computeRawX(value), axis.isInside(), position, isAxisVertical)) {
                this.rawValuesTab[position][valueToDrawIndex] = rawValue;
                this.valuesToDrawTab[position][valueToDrawIndex] = axisValue;
                ++valueToDrawIndex;
            }
            ++valueIndex;
        }
        this.valuesToDrawNumTab[position] = valueToDrawIndex;
    }

    private void prepareAutoGeneratedAxis(Axis axis, int position) {
        int contentRectDimension;
        float stop;
        float start;
        Viewport visibleViewport = this.computator.getVisibleViewport();
        Rect contentRect = this.computator.getContentRectMinusAllMargins();
        boolean isAxisVertical = this.isAxisVertical(position);
        if (isAxisVertical) {
            start = visibleViewport.bottom;
            stop = visibleViewport.top;
            contentRectDimension = contentRect.height();
        } else {
            start = visibleViewport.left;
            stop = visibleViewport.right;
            contentRectDimension = contentRect.width();
        }
        FloatUtils.computeAutoGeneratedAxisValues(start, stop, contentRectDimension / this.labelDimensionForStepsTab[position] / 2, this.autoValuesBufferTab[position]);
        if (axis.hasLines() && this.linesDrawBufferTab[position].length < this.autoValuesBufferTab[position].valuesNumber * 4) {
            this.linesDrawBufferTab[position] = new float[this.autoValuesBufferTab[position].valuesNumber * 4];
        }
        if (this.rawValuesTab[position].length < this.autoValuesBufferTab[position].valuesNumber) {
            this.rawValuesTab[position] = new float[this.autoValuesBufferTab[position].valuesNumber];
        }
        if (this.autoValuesToDrawTab[position].length < this.autoValuesBufferTab[position].valuesNumber) {
            this.autoValuesToDrawTab[position] = new float[this.autoValuesBufferTab[position].valuesNumber];
        }
        int valueToDrawIndex = 0;
        for (int i = 0; i < this.autoValuesBufferTab[position].valuesNumber; ++i) {
            float rawValue = isAxisVertical ? this.computator.computeRawY(this.autoValuesBufferTab[position].values[i]) : this.computator.computeRawX(this.autoValuesBufferTab[position].values[i]);
            if (!this.checkRawValue(contentRect, rawValue, axis.isInside(), position, isAxisVertical)) continue;
            this.rawValuesTab[position][valueToDrawIndex] = rawValue;
            this.autoValuesToDrawTab[position][valueToDrawIndex] = this.autoValuesBufferTab[position].values[i];
            ++valueToDrawIndex;
        }
        this.valuesToDrawNumTab[position] = valueToDrawIndex;
    }

    private boolean checkRawValue(Rect rect, float rawValue, boolean axisInside, int position, boolean isVertical) {
        if (axisInside) {
            if (isVertical) {
                float marginBottom = this.labelTextAscentTab[3] + this.axisMargin;
                float marginTop = this.labelTextAscentTab[0] + this.axisMargin;
                return rawValue <= (float)rect.bottom - marginBottom && rawValue >= (float)rect.top + marginTop;
            }
            float margin = this.labelWidthTab[position] / 2;
            return rawValue >= (float)rect.left + margin && rawValue <= (float)rect.right - margin;
        }
        return true;
    }

    private void drawAxisLines(Canvas canvas, Axis axis, int position) {
        Rect contentRectMargins = this.computator.getContentRectMinusAxesMargins();
        float separationY2 = 0.0f;
        float separationX2 = 0.0f;
        float separationY1 = 0.0f;
        float separationX1 = 0.0f;
        float lineY2 = 0.0f;
        float lineX2 = 0.0f;
        float lineY1 = 0.0f;
        float lineX1 = 0.0f;
        boolean isAxisVertical = this.isAxisVertical(position);
        if (1 == position || 2 == position) {
            separationX1 = separationX2 = this.separationLineTab[position];
            separationY1 = contentRectMargins.bottom;
            separationY2 = contentRectMargins.top;
            lineX1 = contentRectMargins.left;
            lineX2 = contentRectMargins.right;
        } else if (0 == position || 3 == position) {
            separationX1 = contentRectMargins.left;
            separationX2 = contentRectMargins.right;
            separationY1 = separationY2 = this.separationLineTab[position];
            lineY1 = contentRectMargins.top;
            lineY2 = contentRectMargins.bottom;
        }
        if (axis.hasSeparationLine()) {
            canvas.drawLine(separationX1, separationY1, separationX2, separationY2, this.labelPaintTab[position]);
        }
        if (axis.hasLines()) {
            int valueToDrawIndex;
            for (valueToDrawIndex = 0; valueToDrawIndex < this.valuesToDrawNumTab[position]; ++valueToDrawIndex) {
                if (isAxisVertical) {
                    lineY1 = lineY2 = this.rawValuesTab[position][valueToDrawIndex];
                } else {
                    lineX1 = lineX2 = this.rawValuesTab[position][valueToDrawIndex];
                }
                this.linesDrawBufferTab[position][valueToDrawIndex * 4 + 0] = lineX1;
                this.linesDrawBufferTab[position][valueToDrawIndex * 4 + 1] = lineY1;
                this.linesDrawBufferTab[position][valueToDrawIndex * 4 + 2] = lineX2;
                this.linesDrawBufferTab[position][valueToDrawIndex * 4 + 3] = lineY2;
            }
            canvas.drawLines(this.linesDrawBufferTab[position], 0, valueToDrawIndex * 4, this.linePaintTab[position]);
        }
    }

    private void drawAxisLabelsAndName(Canvas canvas, Axis axis, int position) {
        float labelY = 0.0f;
        float labelX = 0.0f;
        boolean isAxisVertical = this.isAxisVertical(position);
        if (1 == position || 2 == position) {
            labelX = this.labelBaselineTab[position];
        } else if (0 == position || 3 == position) {
            labelY = this.labelBaselineTab[position];
        }
        for (int valueToDrawIndex = 0; valueToDrawIndex < this.valuesToDrawNumTab[position]; ++valueToDrawIndex) {
            int charsNumber = 0;
            if (axis.isAutoGenerated()) {
                float value = this.autoValuesToDrawTab[position][valueToDrawIndex];
                charsNumber = axis.getFormatter().formatValueForAutoGeneratedAxis(this.labelBuffer, value, this.autoValuesBufferTab[position].decimals);
            } else {
                AxisValue axisValue = this.valuesToDrawTab[position][valueToDrawIndex];
                charsNumber = axis.getFormatter().formatValueForManualAxis(this.labelBuffer, axisValue);
            }
            if (isAxisVertical) {
                labelY = this.rawValuesTab[position][valueToDrawIndex];
            } else {
                labelX = this.rawValuesTab[position][valueToDrawIndex];
            }
            if (axis.hasTiltedLabels()) {
                canvas.save();
                canvas.translate((float)this.tiltedLabelXTranslation[position], (float)this.tiltedLabelYTranslation[position]);
                canvas.rotate(-45.0f, labelX, labelY);
                canvas.drawText(this.labelBuffer, this.labelBuffer.length - charsNumber, charsNumber, labelX, labelY, this.labelPaintTab[position]);
                canvas.restore();
                continue;
            }
            canvas.drawText(this.labelBuffer, this.labelBuffer.length - charsNumber, charsNumber, labelX, labelY, this.labelPaintTab[position]);
        }
        Rect contentRectMargins = this.computator.getContentRectMinusAxesMargins();
        if (!TextUtils.isEmpty((CharSequence)axis.getName())) {
            if (isAxisVertical) {
                canvas.save();
                canvas.rotate(-90.0f, (float)contentRectMargins.centerY(), (float)contentRectMargins.centerY());
                canvas.drawText(axis.getName(), (float)contentRectMargins.centerY(), this.nameBaselineTab[position], this.namePaintTab[position]);
                canvas.restore();
            } else {
                canvas.drawText(axis.getName(), (float)contentRectMargins.centerX(), this.nameBaselineTab[position], this.namePaintTab[position]);
            }
        }
    }

    private boolean isAxisVertical(int position) {
        if (1 == position || 2 == position) {
            return true;
        }
        if (0 == position || 3 == position) {
            return false;
        }
        throw new IllegalArgumentException("Invalid axis position " + position);
    }
}

