/*
 * Decompiled with CFR 0.152.
 */
package lecho.lib.hellocharts.animation;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import lecho.lib.hellocharts.animation.ChartAnimationListener;
import lecho.lib.hellocharts.animation.DummyChartAnimationListener;
import lecho.lib.hellocharts.animation.PieChartRotationAnimator;
import lecho.lib.hellocharts.view.PieChartView;

@SuppressLint(value={"NewApi"})
public class PieChartRotationAnimatorV14
implements PieChartRotationAnimator,
Animator.AnimatorListener,
ValueAnimator.AnimatorUpdateListener {
    private ValueAnimator animator;
    private final PieChartView chart;
    private float startRotation = 0.0f;
    private float targetRotation = 0.0f;
    private ChartAnimationListener animationListener = new DummyChartAnimationListener();

    public PieChartRotationAnimatorV14(PieChartView chart) {
        this(chart, 200L);
    }

    public PieChartRotationAnimatorV14(PieChartView chart, long duration) {
        this.chart = chart;
        this.animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.animator.setDuration(duration);
        this.animator.addListener((Animator.AnimatorListener)this);
        this.animator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
    }

    @Override
    public void startAnimation(float startRotation, float targetRotation) {
        this.startRotation = (startRotation % 360.0f + 360.0f) % 360.0f;
        this.targetRotation = (targetRotation % 360.0f + 360.0f) % 360.0f;
        this.animator.start();
    }

    @Override
    public void cancelAnimation() {
        this.animator.cancel();
    }

    public void onAnimationUpdate(ValueAnimator animation) {
        float scale = animation.getAnimatedFraction();
        float rotation = this.startRotation + (this.targetRotation - this.startRotation) * scale;
        rotation = (rotation % 360.0f + 360.0f) % 360.0f;
        this.chart.setChartRotation((int)rotation, false);
    }

    public void onAnimationCancel(Animator animation) {
    }

    public void onAnimationEnd(Animator animation) {
        this.chart.setChartRotation((int)this.targetRotation, false);
        this.animationListener.onAnimationFinished();
    }

    public void onAnimationRepeat(Animator animation) {
    }

    public void onAnimationStart(Animator animation) {
        this.animationListener.onAnimationStarted();
    }

    @Override
    public boolean isAnimationStarted() {
        return this.animator.isStarted();
    }

    @Override
    public void setChartAnimationListener(ChartAnimationListener animationListener) {
        this.animationListener = null == animationListener ? new DummyChartAnimationListener() : animationListener;
    }
}

