/*
 * Decompiled with CFR 0.152.
 */
package com.github.lassana.circletimerwidget.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RadialGradient;
import android.graphics.Shader;
import android.os.Build;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.view.AccessibilityDelegateCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.ExploreByTouchHelper;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.github.lassana.circletimerwidget.widget.CircleTimerListener;
import com.github.lassana.circletimerwidget.widget.CircleTimerSavedState;
import com.github.lassana.circletimerwidget.widget.CircleTimerTouchHelper;
import com.github.lassana.circletimerwidget.widget.R;

public class CircleTimerView
extends View {
    public static final boolean IS_LAYER_TYPES_AVAILABLE = Build.VERSION.SDK_INT >= 11;
    private int mStartColor;
    private int mEndColor;
    private int mInnerColor;
    private int mOuterColor;
    private float mCircleLineWidth;
    private float mHitchSize;
    private float mHitchPadding;
    private int mHitchCount;
    private float mIndicatorSize;
    private float mIndicatorPadding;
    private GestureDetector.OnGestureListener mGestureListener = new GestureDetector.SimpleOnGestureListener(){

        public boolean onDown(MotionEvent e) {
            CircleTimerView.this.handleMotionEvent(e);
            return super.onDown(e);
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            CircleTimerView.this.handleMotionEvent(e2);
            return super.onScroll(e1, e2, distanceX, distanceY);
        }
    };
    private Paint mExternalCirclePaint;
    private Paint mInternalCirclePaint;
    private Paint mExternalCircleWithShadowPaint;
    private PointF[] mHitchPositionData;
    private int mIndicatorPosition = 0;
    private int mCanvasWidth;
    private int mCanvasHeight;
    private int mRadius;
    private CircleTimerListener mCircleTimerListener;
    private ExploreByTouchHelper mExploreByTouchHelper;
    private CharSequence[] mHitchNames;

    public CircleTimerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(attrs);
        this.initView();
    }

    public CircleTimerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(attrs);
        this.initView();
    }

    @TargetApi(value=21)
    public CircleTimerView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initAttrs(attrs);
        this.initView();
    }

    private void initAttrs(@NonNull AttributeSet attrs) {
        TypedArray array = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.CircleTimerWidget, 0, 0);
        try {
            this.mStartColor = array.getColor(R.styleable.CircleTimerWidget_start_color, Color.parseColor((String)"#A6A1A4"));
            this.mEndColor = array.getColor(R.styleable.CircleTimerWidget_end_color, Color.parseColor((String)"#333133"));
            this.mInnerColor = array.getColor(R.styleable.CircleTimerWidget_inner_color, Color.parseColor((String)"#F2EDF0"));
            this.mOuterColor = array.getColor(R.styleable.CircleTimerWidget_outer_color, Color.parseColor((String)"#D1CDD0"));
            this.mCircleLineWidth = array.getDimensionPixelSize(R.styleable.CircleTimerWidget_circle_line_width, 3);
            this.mHitchSize = array.getDimensionPixelSize(R.styleable.CircleTimerWidget_hitch_size, 45);
            this.mHitchPadding = array.getDimensionPixelSize(R.styleable.CircleTimerWidget_hitch_padding, 30);
            this.mHitchCount = array.getInt(R.styleable.CircleTimerWidget_hitch_count, 12);
            this.mIndicatorSize = array.getDimensionPixelSize(R.styleable.CircleTimerWidget_indicator_size, 50);
            this.mIndicatorPadding = array.getDimensionPixelSize(R.styleable.CircleTimerWidget_indicator_padding, 15);
            this.mHitchNames = array.getTextArray(R.styleable.CircleTimerWidget_android_entries);
            if (this.mHitchNames != null && this.mHitchNames.length != this.mHitchCount) {
                throw new IllegalArgumentException("Length of \"android:entries\" array should equals to hitch count!");
            }
        }
        finally {
            array.recycle();
        }
    }

    @TargetApi(value=11)
    private void initView() {
        if (!this.isInEditMode()) {
            final GestureDetector gestureDetector = new GestureDetector(this.getContext(), this.mGestureListener);
            this.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    gestureDetector.onTouchEvent(event);
                    return true;
                }
            });
        }
        this.setWillNotDraw(false);
        this.mExploreByTouchHelper = new CircleTimerTouchHelper(this);
        ViewCompat.setAccessibilityDelegate((View)this, (AccessibilityDelegateCompat)this.mExploreByTouchHelper);
    }

    protected Parcelable onSaveInstanceState() {
        CircleTimerSavedState state = new CircleTimerSavedState(super.onSaveInstanceState());
        state.position = this.mIndicatorPosition;
        return state;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof CircleTimerSavedState) {
            CircleTimerSavedState savedState = (CircleTimerSavedState)state;
            super.onRestoreInstanceState(savedState.getSuperState());
            this.mIndicatorPosition = savedState.position;
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    @TargetApi(value=11)
    protected void onDraw(Canvas canvas) {
        LinearGradient gradient;
        super.onDraw(canvas);
        int measuredWidth = this.getMeasuredWidth();
        int measuredHeight = this.getMeasuredHeight();
        if (this.mExternalCirclePaint == null || this.mExternalCircleWithShadowPaint == null) {
            this.mExternalCirclePaint = new Paint();
            gradient = new LinearGradient(0.0f, 0.0f, (float)measuredWidth, (float)measuredHeight, this.mStartColor, this.mEndColor, Shader.TileMode.CLAMP);
            this.mExternalCirclePaint.setShader((Shader)gradient);
            this.mExternalCirclePaint.setStyle(Paint.Style.STROKE);
            this.mExternalCirclePaint.setStrokeWidth(this.mCircleLineWidth);
            this.mExternalCirclePaint.setAntiAlias(true);
            this.mExternalCircleWithShadowPaint = new Paint(this.mExternalCirclePaint);
            if (!this.isInEditMode()) {
                this.mExternalCircleWithShadowPaint.setShadowLayer(4.0f, 0.0f, 2.0f, -16777216);
                if (IS_LAYER_TYPES_AVAILABLE) {
                    this.setLayerType(1, this.mExternalCircleWithShadowPaint);
                }
            }
        }
        if (this.mInternalCirclePaint == null) {
            this.mInternalCirclePaint = new Paint();
            gradient = new RadialGradient((float)(measuredWidth / 2), (float)(measuredHeight / 2), (float)(Math.min(measuredHeight, measuredWidth) / 2), this.mInnerColor, this.mOuterColor, Shader.TileMode.CLAMP);
            this.mInternalCirclePaint.setShader((Shader)gradient);
            this.mInternalCirclePaint.setAntiAlias(true);
        }
        this.mCanvasWidth = canvas.getWidth();
        this.mCanvasHeight = canvas.getHeight();
        this.mRadius = Math.min(this.mCanvasWidth, this.mCanvasHeight) / 2;
        float circleCenterX = this.mCanvasWidth / 2;
        float circleCenterY = this.mCanvasHeight / 2;
        canvas.drawCircle(circleCenterX, circleCenterY, (float)this.mRadius - this.mHitchSize, this.mExternalCircleWithShadowPaint);
        canvas.drawCircle(circleCenterX, circleCenterY, (float)this.mRadius - this.mHitchSize - this.mCircleLineWidth / 2.0f, this.mInternalCirclePaint);
        if (this.mHitchPositionData == null) {
            this.mHitchPositionData = new PointF[this.mHitchCount];
            for (int i = 0; i < this.mHitchCount; ++i) {
                double angle = Math.toRadians((float)i / (float)this.mHitchCount * 360.0f - 90.0f);
                this.mHitchPositionData[i] = new PointF((float)((double)circleCenterX + (double)((float)this.mRadius - this.mHitchSize / 2.0f) * Math.cos(angle)), (float)((double)circleCenterY + (double)((float)this.mRadius - this.mHitchSize / 2.0f) * Math.sin(angle)));
            }
        }
        for (PointF nextPosition : this.mHitchPositionData) {
            canvas.drawCircle(nextPosition.x, nextPosition.y, (this.mHitchSize - this.mHitchPadding) / 2.0f, this.mExternalCirclePaint);
            canvas.drawCircle(nextPosition.x, nextPosition.y, (this.mHitchSize - this.mHitchPadding) / 2.0f - this.mCircleLineWidth / 2.0f, this.mInternalCirclePaint);
        }
        double indicatorAngle = Math.toRadians((float)this.mIndicatorPosition / (float)this.mHitchCount * 360.0f - 90.0f);
        float indicatorX = (float)((double)circleCenterX + (double)((float)this.mRadius - this.mHitchSize - this.mCircleLineWidth - this.mIndicatorSize / 2.0f) * Math.cos(indicatorAngle));
        float indicatorY = (float)((double)circleCenterY + (double)((float)this.mRadius - this.mHitchSize - this.mCircleLineWidth - this.mIndicatorSize / 2.0f) * Math.sin(indicatorAngle));
        canvas.drawCircle(indicatorX, indicatorY, (this.mIndicatorSize - this.mIndicatorPadding) / 2.0f, this.mExternalCirclePaint);
    }

    private void handleMotionEvent(MotionEvent e) {
        int indicatorPosition = this.calculateZoneIndex(e.getX(), e.getY());
        if (indicatorPosition != this.mIndicatorPosition) {
            this.mIndicatorPosition = indicatorPosition;
            this.invalidate();
            if (this.mCircleTimerListener != null) {
                this.mCircleTimerListener.onPositionChanged(this.mIndicatorPosition);
            }
        }
    }

    protected int calculateZoneIndex(float touchX, float touchY) {
        float lastMinDistance = Float.MAX_VALUE;
        int rvalue = this.mIndicatorPosition;
        float radius = Math.min(this.mCanvasWidth, this.mCanvasHeight) / 2;
        float x = this.mCanvasWidth / 2;
        float y = this.mCanvasHeight / 2;
        for (int i = 0; i < this.mHitchCount; ++i) {
            float endY;
            double angle = Math.toRadians((float)i / (float)this.mHitchCount * 360.0f - 90.0f);
            float endX = (float)((double)x + (double)radius * Math.cos(angle));
            float distance = (float)Math.sqrt((touchX - endX) * (touchX - endX) + (touchY - (endY = (float)((double)y + (double)radius * Math.sin(angle)))) * (touchY - endY));
            if (!(distance < lastMinDistance)) continue;
            rvalue = i;
            lastMinDistance = distance;
        }
        return rvalue;
    }

    public void setCircleTimerListener(CircleTimerListener circleTimerListener) {
        this.mCircleTimerListener = circleTimerListener;
    }

    public int getIndicatorPosition() {
        return this.mIndicatorPosition;
    }

    public void setIndicatorPosition(int newPosition) {
        if (newPosition < 0) {
            throw new IllegalArgumentException("New position value cannot be smaller than zero!");
        }
        if (newPosition >= this.mHitchCount) {
            throw new IllegalArgumentException("New position value cannot be larger that count of hitch!");
        }
        this.mIndicatorPosition = newPosition;
        this.invalidate();
    }

    public int getHitchCount() {
        return this.mHitchCount;
    }

    @TargetApi(value=14)
    protected boolean dispatchHoverEvent(@NonNull MotionEvent event) {
        if (this.mExploreByTouchHelper != null && this.mExploreByTouchHelper.dispatchHoverEvent(event)) {
            return true;
        }
        return super.dispatchHoverEvent(event);
    }

    protected CharSequence[] getHitchNames() {
        return this.mHitchNames;
    }

    protected int getRadius() {
        return this.mRadius;
    }

    protected int getCanvasWidth() {
        return this.mCanvasWidth;
    }

    protected int getCanvasHeight() {
        return this.mCanvasHeight;
    }
}

