/*
 * Decompiled with CFR 0.152.
 */
package com.fourmob.datetimepicker.date;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.fourmob.datetimepicker.R;
import com.fourmob.datetimepicker.Utils;
import com.fourmob.datetimepicker.date.CalendarDay;
import com.fourmob.datetimepicker.date.SimpleMonthPagerAdapter;

public class DayPickerView
extends FrameLayout
implements SimpleMonthPagerAdapter.MonthPagerListener {
    private ViewPager mViewPager;
    private SimpleMonthPagerAdapter mPagerAdapter;
    private ImageView mBackButton;
    private ImageView mForwardButton;
    private DayPickerListener mListener;

    public DayPickerView(Context context, DayPickerParams params) {
        super(context);
        this.init(context, params);
    }

    private void init(Context context, DayPickerParams params) {
        LayoutInflater.from((Context)context).inflate(R.layout.day_picker, (ViewGroup)this, true);
        this.mBackButton = (ImageView)this.findViewById(R.id.day_picker_back);
        this.mForwardButton = (ImageView)this.findViewById(R.id.day_picker_forward);
        this.setNavigationSelector(this.mBackButton);
        this.setNavigationSelector(this.mForwardButton);
        this.mBackButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int currentItem = DayPickerView.this.mViewPager.getCurrentItem();
                if (currentItem > 0) {
                    DayPickerView.this.mViewPager.setCurrentItem(currentItem - 1, true);
                }
            }
        });
        this.mForwardButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int currentItem = DayPickerView.this.mViewPager.getCurrentItem();
                if (currentItem < DayPickerView.this.mPagerAdapter.getCount()) {
                    DayPickerView.this.mViewPager.setCurrentItem(currentItem + 1, true);
                }
            }
        });
        this.mViewPager = (ViewPager)this.findViewById(R.id.day_picker_pager);
        this.mViewPager.setPageMargin(context.getResources().getDimensionPixelSize(R.dimen.day_picker_pager_margin));
        this.mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                DayPickerView.this.updateNavigationButtons();
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.mPagerAdapter = new SimpleMonthPagerAdapter(params);
        this.mPagerAdapter.setListener(this);
        this.mViewPager.setAdapter((PagerAdapter)this.mPagerAdapter);
        this.updatePosition(params);
    }

    private void setNavigationSelector(ImageView navigationButton) {
        ColorStateList colours = this.getResources().getColorStateList(R.color.chevron_selector);
        Drawable d = DrawableCompat.wrap((Drawable)navigationButton.getDrawable());
        DrawableCompat.setTintList((Drawable)d, (ColorStateList)colours);
        navigationButton.setImageDrawable(d);
    }

    private void updateNavigationButtons() {
        int currentItem = this.mViewPager.getCurrentItem();
        int count = this.mPagerAdapter.getCount();
        this.mBackButton.setEnabled(count > 1 && currentItem != 0);
        this.mForwardButton.setEnabled(count > 1 && currentItem != count - 1);
    }

    public void updateParams(DayPickerParams params) {
        this.mPagerAdapter.updateParams(params, true);
        this.updatePosition(params);
    }

    private void updatePosition(DayPickerParams params) {
        int position = Utils.getMonthsBetweenDates(params.minDate.month, params.minDate.year, params.selectedDate.month, params.selectedDate.year) - 1;
        this.mViewPager.setCurrentItem(position);
        this.updateNavigationButtons();
    }

    @Override
    public void onDateSelected(int year, int month, int day) {
        if (this.mListener != null) {
            this.mListener.onDateSelected(year, month, day);
        }
    }

    public void setListener(DayPickerListener listener) {
        this.mListener = listener;
    }

    public int getCurrentItem() {
        return this.mViewPager.getCurrentItem();
    }

    public void setCurrentItem(int currentItem) {
        this.mViewPager.setCurrentItem(currentItem);
    }

    public static class DayPickerParams {
        public final int firstDayOfWeek;
        public final CalendarDay selectedDate;
        public final CalendarDay minDate;
        public final CalendarDay maxDate;

        public DayPickerParams(CalendarDay minDate, CalendarDay maxDate, CalendarDay selectedDate, int firstDayOfWeek) {
            this.selectedDate = selectedDate;
            this.firstDayOfWeek = firstDayOfWeek;
            this.minDate = minDate;
            this.maxDate = maxDate;
        }
    }

    public static interface DayPickerListener {
        public void onDateSelected(int var1, int var2, int var3);
    }
}

