/*
 * Decompiled with CFR 0.152.
 */
package com.fourmob.datetimepicker.date;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.SystemClock;
import android.os.Vibrator;
import android.support.annotation.NonNull;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.text.format.DateUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.Button;
import android.widget.TextView;
import com.fourmob.datetimepicker.R;
import com.fourmob.datetimepicker.Utils;
import com.fourmob.datetimepicker.date.AccessibleDateAnimator;
import com.fourmob.datetimepicker.date.CalendarDay;
import com.fourmob.datetimepicker.date.DayPickerView;
import com.fourmob.datetimepicker.date.YearPickerView;
import com.nineoldandroids.animation.ObjectAnimator;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

public class DatePickerDialog
extends DialogFragment
implements View.OnClickListener,
YearPickerView.YearPickerListener,
DayPickerView.DayPickerListener {
    private static final String KEY_SELECTED_YEAR = "year";
    private static final String KEY_SELECTED_MONTH = "month";
    private static final String KEY_SELECTED_DAY = "day";
    private static final String KEY_VIBRATE = "vibrate";
    private static final String KEY_PULSE_ANIMATE = "pulse_animate";
    private static final CalendarDay MINIMUM_POSSIBLE_DATE = new CalendarDay(1902, 1, 1);
    private static final CalendarDay MAXIMUM_POSSIBLE_DATE = new CalendarDay(2037, 12, 31);
    private static final int UNINITIALIZED = -1;
    private static final int MONTH_AND_DAY_VIEW = 0;
    private static final int YEAR_VIEW = 1;
    public static final int ANIMATION_DELAY = 500;
    public static final String KEY_WEEK_START = "week_start";
    public static final String KEY_MIN_DATE = "min_date";
    public static final String KEY_MAX_DATE = "max_date";
    public static final String KEY_CURRENT_VIEW = "current_view";
    public static final String KEY_LIST_POSITION = "list_position";
    public static final String KEY_LIST_POSITION_OFFSET = "list_position_offset";
    private static SimpleDateFormat DAY_MONTH_FORMAT = new SimpleDateFormat("EEE, dd MMM", Locale.getDefault());
    private static SimpleDateFormat YEAR_FORMAT = new SimpleDateFormat("yyyy", Locale.getDefault());
    private final Calendar mCalendar = Calendar.getInstance();
    private OnDateSetListener mCallBack;
    private AccessibleDateAnimator mAnimator;
    private boolean mDelayAnimation = true;
    private long mLastVibrate;
    private int mCurrentView = -1;
    private int mWeekStart = this.mCalendar.getFirstDayOfWeek();
    private String mDayPickerDescription;
    private String mYearPickerDescription;
    private String mSelectDay;
    private String mSelectYear;
    private DayPickerView mDayPickerView;
    private TextView mMonthAndDayView;
    private Vibrator mVibrator;
    private YearPickerView mYearPickerView;
    private TextView mYearView;
    private boolean mVibrate = true;
    private boolean mUsePulseAnimations = true;
    private boolean mCloseOnSingleTapDay;
    @NonNull
    private CalendarDay mMinDate = MINIMUM_POSSIBLE_DATE;
    @NonNull
    private CalendarDay mMaxDate = MAXIMUM_POSSIBLE_DATE;
    private boolean mIsViewInitialized = false;

    public static DatePickerDialog newInstance(OnDateSetListener onDateSetListener, int year, int month, int day) {
        return DatePickerDialog.newInstance(onDateSetListener, year, month, day, true);
    }

    public static DatePickerDialog newInstance(OnDateSetListener onDateSetListener, int year, int month, int day, boolean vibrate) {
        DatePickerDialog datePickerDialog = new DatePickerDialog();
        datePickerDialog.initialize(onDateSetListener, year, month, day, vibrate);
        return datePickerDialog;
    }

    private void initialize(OnDateSetListener onDateSetListener, int year, int month, int day, boolean vibrate) {
        if (year > DatePickerDialog.MAXIMUM_POSSIBLE_DATE.year) {
            throw new IllegalArgumentException("year end must < " + DatePickerDialog.MAXIMUM_POSSIBLE_DATE.year);
        }
        if (year < DatePickerDialog.MINIMUM_POSSIBLE_DATE.year) {
            throw new IllegalArgumentException("year end must > " + DatePickerDialog.MINIMUM_POSSIBLE_DATE.year);
        }
        this.mCallBack = onDateSetListener;
        this.mCalendar.set(1, year);
        this.mCalendar.set(2, month);
        this.mCalendar.set(5, day);
        this.mVibrate = vibrate;
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        FragmentActivity activity = this.getActivity();
        activity.getWindow().setSoftInputMode(3);
        this.mVibrator = (Vibrator)activity.getSystemService("vibrator");
        if (bundle != null) {
            this.mCalendar.set(1, bundle.getInt(KEY_SELECTED_YEAR));
            this.mCalendar.set(2, bundle.getInt(KEY_SELECTED_MONTH));
            this.mCalendar.set(5, bundle.getInt(KEY_SELECTED_DAY));
            CalendarDay savedMinDate = (CalendarDay)bundle.getParcelable(KEY_MIN_DATE);
            this.mMinDate = savedMinDate != null ? savedMinDate : MINIMUM_POSSIBLE_DATE;
            CalendarDay savedMaxDate = (CalendarDay)bundle.getParcelable(KEY_MAX_DATE);
            this.mMaxDate = savedMaxDate != null ? savedMaxDate : MAXIMUM_POSSIBLE_DATE;
            this.mVibrate = bundle.getBoolean(KEY_VIBRATE);
            this.mUsePulseAnimations = bundle.getBoolean(KEY_PULSE_ANIMATE);
        }
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup parent, Bundle bundle) {
        this.getDialog().getWindow().requestFeature(1);
        this.mIsViewInitialized = true;
        View view = layoutInflater.inflate(R.layout.date_picker_dialog, parent, false);
        this.mMonthAndDayView = (TextView)view.findViewById(R.id.date_picker_month_and_day);
        this.mMonthAndDayView.setOnClickListener((View.OnClickListener)this);
        this.mYearView = (TextView)view.findViewById(R.id.date_picker_year);
        this.mYearView.setOnClickListener((View.OnClickListener)this);
        int listPosition = -1;
        int currentView = 0;
        int listPositionOffset = 0;
        if (bundle != null) {
            this.mWeekStart = bundle.getInt(KEY_WEEK_START);
            currentView = bundle.getInt(KEY_CURRENT_VIEW);
            listPosition = bundle.getInt(KEY_LIST_POSITION);
            listPositionOffset = bundle.getInt(KEY_LIST_POSITION_OFFSET);
        }
        FragmentActivity activity = this.getActivity();
        this.mDayPickerView = new DayPickerView((Context)activity, this.createDayPickerParams());
        this.mDayPickerView.setListener(this);
        this.mYearPickerView = new YearPickerView((Context)activity);
        this.mYearPickerView.setListener(this);
        Resources resources = this.getResources();
        this.mDayPickerDescription = resources.getString(R.string.day_picker_description);
        this.mSelectDay = resources.getString(R.string.select_day);
        this.mYearPickerDescription = resources.getString(R.string.year_picker_description);
        this.mSelectYear = resources.getString(R.string.select_year);
        this.mAnimator = (AccessibleDateAnimator)view.findViewById(R.id.animator);
        this.mAnimator.addView((View)this.mDayPickerView);
        this.mAnimator.addView((View)this.mYearPickerView);
        this.mAnimator.setDateMillis(this.mCalendar.getTimeInMillis());
        AlphaAnimation inAlphaAnimation = new AlphaAnimation(0.0f, 1.0f);
        inAlphaAnimation.setDuration(300L);
        this.mAnimator.setInAnimation((Animation)inAlphaAnimation);
        AlphaAnimation outAlphaAnimation = new AlphaAnimation(1.0f, 0.0f);
        outAlphaAnimation.setDuration(300L);
        this.mAnimator.setOutAnimation((Animation)outAlphaAnimation);
        Button doneButton = (Button)view.findViewById(R.id.done_button);
        Button cancelButton = (Button)view.findViewById(R.id.cancel_button);
        doneButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                DatePickerDialog.this.onDoneButtonClick();
            }
        });
        cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DatePickerDialog.this.dismiss();
            }
        });
        ColorStateList selector = Utils.createThemedTextColorStateList((Context)activity);
        doneButton.setTextColor(selector);
        cancelButton.setTextColor(selector);
        this.updateTitleContent(false);
        this.setCurrentPicker(currentView, true);
        if (listPosition != -1) {
            if (currentView == 0) {
                this.mDayPickerView.setCurrentItem(listPosition);
            }
            if (currentView == 1) {
                this.mYearPickerView.postSetSelectionFromTop(listPosition, listPositionOffset);
            }
        }
        return view;
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putInt(KEY_SELECTED_YEAR, this.mCalendar.get(1));
        bundle.putInt(KEY_SELECTED_MONTH, this.mCalendar.get(2));
        bundle.putInt(KEY_SELECTED_DAY, this.mCalendar.get(5));
        bundle.putInt(KEY_WEEK_START, this.mWeekStart);
        bundle.putParcelable(KEY_MIN_DATE, (Parcelable)this.mMinDate);
        bundle.putParcelable(KEY_MAX_DATE, (Parcelable)this.mMaxDate);
        bundle.putInt(KEY_CURRENT_VIEW, this.mCurrentView);
        int listPosition = -1;
        if (this.mCurrentView == 0) {
            listPosition = this.mDayPickerView.getCurrentItem();
        }
        if (this.mCurrentView == 1) {
            listPosition = this.mYearPickerView.getFirstVisiblePosition();
            bundle.putInt(KEY_LIST_POSITION_OFFSET, this.mYearPickerView.getFirstPositionOffset());
        }
        bundle.putInt(KEY_LIST_POSITION, listPosition);
        bundle.putBoolean(KEY_VIBRATE, this.mVibrate);
        bundle.putBoolean(KEY_PULSE_ANIMATE, this.mUsePulseAnimations);
    }

    public void onClick(View view) {
        this.tryVibrate();
        if (view.getId() == R.id.date_picker_year) {
            this.setCurrentPicker(1);
        } else if (view.getId() == R.id.date_picker_month_and_day) {
            this.setCurrentPicker(0);
        }
    }

    @Override
    public void onYearSelected(int year) {
        this.tryVibrate();
        int day = this.mCalendar.get(5);
        int month = this.mCalendar.get(2);
        int daysInMonth = Utils.getDaysInMonth(month, year);
        if (day > daysInMonth) {
            day = daysInMonth;
        }
        if (year == this.mMinDate.year) {
            if (month < this.mMinDate.month) {
                month = this.mMinDate.month;
            }
            if (month == this.mMinDate.month && day < this.mMinDate.day) {
                day = this.mMinDate.day;
            }
        }
        if (year == this.mMaxDate.year) {
            if (month > this.mMaxDate.month) {
                month = this.mMaxDate.month;
            }
            if (month == this.mMaxDate.month && day > this.mMaxDate.day) {
                day = this.mMaxDate.day;
            }
        }
        this.mCalendar.set(5, day);
        this.mCalendar.set(2, month);
        this.mCalendar.set(1, year);
        this.setCurrentPicker(0);
        this.updateTitleContent(true);
    }

    @Override
    public void onDateSelected(int year, int month, int day) {
        this.setSelectedDate(year, month, day);
    }

    public void setFirstDayOfWeek(int startOfWeek) {
        if (startOfWeek < 1 || startOfWeek > 7) {
            throw new IllegalArgumentException("Value must be between Calendar.SUNDAY and Calendar.SATURDAY");
        }
        this.mWeekStart = startOfWeek;
        this.updateDayPickerParams();
    }

    public void setOnDateSetListener(OnDateSetListener onDateSetListener) {
        this.mCallBack = onDateSetListener;
    }

    public void setSelectedDate(int year, int month, int day) {
        this.mCalendar.set(1, year);
        this.mCalendar.set(2, month);
        this.mCalendar.set(5, day);
        if (this.mIsViewInitialized) {
            this.updateDayPickerParams();
            this.updateTitleContent(true);
            if (this.mCloseOnSingleTapDay) {
                this.onDoneButtonClick();
            }
        }
    }

    public void setMinDate(CalendarDay minDate) {
        this.setDateConstaints(minDate, this.mMaxDate);
    }

    public void setMaxDate(CalendarDay maxDate) {
        this.setDateConstaints(this.mMinDate, maxDate);
    }

    public void setYearRange(int minYear, int maxYear) {
        this.setDateConstaints(new CalendarDay(minYear, this.mMinDate.month, this.mMinDate.day), new CalendarDay(maxYear, this.mMaxDate.month, this.mMaxDate.day));
    }

    public void setDateConstaints(CalendarDay minDate, CalendarDay maxDate) {
        if (minDate.isAfter(maxDate)) {
            throw new IllegalArgumentException("Max date must be larger than min date");
        }
        if (minDate.year < DatePickerDialog.MINIMUM_POSSIBLE_DATE.year) {
            throw new IllegalArgumentException("Min date year end must > " + DatePickerDialog.MINIMUM_POSSIBLE_DATE.year);
        }
        if (maxDate.year > DatePickerDialog.MAXIMUM_POSSIBLE_DATE.year) {
            throw new IllegalArgumentException("Max date year end must < " + DatePickerDialog.MAXIMUM_POSSIBLE_DATE.year);
        }
        this.mMinDate = minDate;
        this.mMaxDate = maxDate;
        this.updateDayPickerParams();
    }

    public void setCloseOnSingleTapDay(boolean closeOnSingleTapDay) {
        this.mCloseOnSingleTapDay = closeOnSingleTapDay;
    }

    public void setVibrate(boolean vibrate) {
        this.mVibrate = vibrate;
    }

    public void setPulseAnimationsEnabled(boolean usePulseAnimations) {
        this.mUsePulseAnimations = usePulseAnimations;
    }

    private void setCurrentPicker(int pickerId) {
        this.setCurrentPicker(pickerId, false);
    }

    private void setCurrentPicker(int pickerId, boolean forceRefresh) {
        long timeInMillis = this.mCalendar.getTimeInMillis();
        TextView selectedLabel = null;
        boolean monthAndDayViewSelected = false;
        boolean yearViewSelected = false;
        String contentDescription = null;
        String announcement = null;
        switch (pickerId) {
            case 0: {
                selectedLabel = this.mMonthAndDayView;
                this.updateDayPickerParams();
                monthAndDayViewSelected = true;
                String monthDayDesc = DateUtils.formatDateTime((Context)this.getActivity(), (long)timeInMillis, (int)16);
                contentDescription = this.mDayPickerDescription + ": " + monthDayDesc;
                announcement = this.mSelectDay;
                break;
            }
            case 1: {
                selectedLabel = this.mYearView;
                this.mYearPickerView.updateContent(this.getSelectedDay().year, this.mMinDate.year, this.mMaxDate.year);
                yearViewSelected = true;
                contentDescription = this.mYearPickerDescription + ": " + YEAR_FORMAT.format(timeInMillis);
                announcement = this.mSelectYear;
            }
        }
        if (selectedLabel == null) {
            return;
        }
        if (this.mCurrentView != pickerId || forceRefresh) {
            this.mMonthAndDayView.setSelected(monthAndDayViewSelected);
            this.mYearView.setSelected(yearViewSelected);
            this.mAnimator.setDisplayedChild(pickerId);
            this.mCurrentView = pickerId;
        }
        if (this.mUsePulseAnimations) {
            ObjectAnimator pulseAnimator = Utils.getPulseAnimator((View)selectedLabel, 0.9f, 1.05f);
            if (this.mDelayAnimation) {
                pulseAnimator.setStartDelay(500L);
                this.mDelayAnimation = false;
            }
            pulseAnimator.start();
        }
        this.mAnimator.setContentDescription(contentDescription);
        Utils.tryAccessibilityAnnounce((View)this.mAnimator, announcement);
    }

    private void updateTitleContent(boolean announce) {
        this.mCalendar.setFirstDayOfWeek(this.mWeekStart);
        this.mMonthAndDayView.setText((CharSequence)DAY_MONTH_FORMAT.format(this.mCalendar.getTime()));
        this.mYearView.setText((CharSequence)YEAR_FORMAT.format(this.mCalendar.getTime()));
        long millis = this.mCalendar.getTimeInMillis();
        this.mAnimator.setDateMillis(millis);
        int flags = 24;
        String monthAndDayText = DateUtils.formatDateTime((Context)this.getActivity(), (long)millis, (int)flags);
        this.mMonthAndDayView.setContentDescription((CharSequence)monthAndDayText);
        if (announce) {
            flags = 20;
            String fullDateText = DateUtils.formatDateTime((Context)this.getActivity(), (long)millis, (int)flags);
            Utils.tryAccessibilityAnnounce((View)this.mAnimator, fullDateText);
        }
    }

    private CalendarDay getSelectedDay() {
        return new CalendarDay(this.mCalendar);
    }

    private DayPickerView.DayPickerParams createDayPickerParams() {
        return new DayPickerView.DayPickerParams(this.mMinDate, this.mMaxDate, new CalendarDay(this.mCalendar), this.mWeekStart);
    }

    private void updateDayPickerParams() {
        if (this.mDayPickerView == null) {
            return;
        }
        this.mDayPickerView.updateParams(this.createDayPickerParams());
    }

    private void onDoneButtonClick() {
        this.tryVibrate();
        if (this.mCallBack != null) {
            this.mCallBack.onDateSet(this, this.mCalendar.get(1), this.mCalendar.get(2), this.mCalendar.get(5));
        }
        this.dismiss();
    }

    private void tryVibrate() {
        long timeInMillis;
        if (this.mVibrator != null && this.mVibrate && (timeInMillis = SystemClock.uptimeMillis()) - this.mLastVibrate >= 125L) {
            this.mVibrator.vibrate(5L);
            this.mLastVibrate = timeInMillis;
        }
    }

    public static interface OnDateSetListener {
        public void onDateSet(DatePickerDialog var1, int var2, int var3, int var4);
    }
}

