/*
 * Decompiled with CFR 0.152.
 */
package in.kyle.api.generate.api;

import in.kyle.api.generate.api.Invoke;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;

@FunctionalInterface
public interface Matcher {
    public boolean matches(Invoke var1);

    public static MatcherBuilder builder() {
        return new MatcherBuilder();
    }

    public static Matcher exact(Method method) {
        return Matcher.builder().nameEquals(method.getName()).argsLength(method.getParameterCount()).build();
    }

    public static class MatcherBuilder {
        private final Set<Function<Invoke, Boolean>> functions = new HashSet<Function<Invoke, Boolean>>();

        public MatcherBuilder nameStartsWith(String ... prefixes) {
            this.functions.add(invoke -> {
                for (String prefix : prefixes) {
                    if (!invoke.getMethod().getName().startsWith(prefix)) continue;
                    return true;
                }
                return false;
            });
            return this;
        }

        public MatcherBuilder nameEquals(String name) {
            this.functions.add(invoke -> invoke.getMethod().getName().equals(name));
            return this;
        }

        public MatcherBuilder argsLength(int length) {
            return this.argsLength(length, length);
        }

        public MatcherBuilder argsLength(int rangeStart, int rangeEnd) {
            this.functions.add(invoke -> {
                int count = invoke.getMethod().getParameterCount();
                return count >= rangeStart && count <= rangeEnd;
            });
            return this;
        }

        public MatcherBuilder args(Class<?> ... argsClasses) {
            this.functions.add(invoke -> {
                Class<?>[] types = invoke.getMethod().getParameterTypes();
                for (int i = 0; i < argsClasses.length; ++i) {
                    if (i >= types.length) {
                        return false;
                    }
                    if (argsClasses[i].isAssignableFrom(types[i])) continue;
                    return false;
                }
                return true;
            });
            return this;
        }

        public MatcherBuilder returnType(Class<?> ... types) {
            this.functions.add(invoke -> Arrays.stream(types).anyMatch(type -> invoke.getMethod().getReturnType().equals(type)));
            return this;
        }

        public Matcher build() {
            return invoke -> this.functions.stream().allMatch(function -> (Boolean)function.apply(invoke));
        }
    }
}

