/*
 * Decompiled with CFR 0.152.
 */
package in.kyle.api.generate.api;

import in.kyle.api.generate.DefaultFunctions;
import in.kyle.api.generate.NotImplementedException;
import in.kyle.api.generate.api.Defaults;
import in.kyle.api.generate.api.GeneratedFunction;
import in.kyle.api.generate.api.Generator;
import in.kyle.api.generate.api.Invoke;
import in.kyle.api.generate.api.Matcher;
import in.kyle.api.generate.helper.ReflectHelper;
import in.kyle.api.utils.Try;
import in.kyle.api.verify.Verify;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javassist.util.proxy.MethodHandler;

public class GeneratorHandler
implements MethodHandler {
    protected final List<GeneratedFunction> functions = new ArrayList<GeneratedFunction>();
    private final Map<String, Object> values = new HashMap<String, Object>();
    private final Generator generator;
    private Object object;

    public GeneratorHandler(Generator generator) {
        this.generator = generator;
        DefaultFunctions.addTo(this);
    }

    public void addFunction(GeneratedFunction function) {
        this.functions.add(function);
    }

    public <T> T getValueOrDefault(String name, T def) {
        Verify.that((String)name).isNotNull();
        Object value = this.getValue(name);
        if (value != null) {
            return (T)value;
        }
        this.setValue(name, def);
        return def;
    }

    public Object getValue(String name) {
        Object temp = this.getFieldValue(name);
        if (temp == null) {
            temp = this.values.get(name);
        }
        return temp;
    }

    public Object getFieldValue(String name) {
        Field field = ReflectHelper.getAccessibleField(this.object.getClass(), name);
        if (field != null) {
            return Try.to(() -> field.get(this.object));
        }
        return null;
    }

    public Object getDefaultReturnValue(Method method) {
        Class<?> returnType = method.getReturnType();
        return Defaults.defaultValue(returnType);
    }

    public void setValue(String name, Object value) {
        Field field = ReflectHelper.getAccessibleField(this.object.getClass(), name);
        if (field == null) {
            this.values.put(name, value);
        } else {
            Try.to(() -> field.set(this.object, value));
        }
    }

    public Object invoke(Object o, Method method, Method proxyMethod, Object[] args) throws Throwable {
        Invoke invoke = new Invoke(method, o, args == null ? new Object[]{} : args);
        GeneratedFunction function = this.functions.stream().filter(e -> e.getMatcher().matches(invoke)).findFirst().orElseThrow(() -> new NotImplementedException(method.toString()));
        return function.invoke(this, invoke);
    }

    public Map<String, Object> getEffectiveValues() throws IllegalAccessException {
        HashMap<String, Object> effective = new HashMap<String, Object>(this.values);
        for (Field field : ReflectHelper.getFields(this.object.getClass())) {
            field.setAccessible(true);
            if (field.get(this.object) == null || Modifier.isStatic(field.getModifiers())) continue;
            effective.put(field.getName(), field.get(this.object));
        }
        return Collections.unmodifiableMap(effective);
    }

    public void createAndAddFunction(Matcher matcher, Function<Invoke, Object> function) {
        this.addFunction(GeneratorHandler.createFunction(matcher, function));
    }

    public static GeneratedFunction createFunction(final Matcher matcher, final Function<Invoke, Object> function) {
        return new GeneratedFunction(){

            @Override
            public Matcher getMatcher() {
                return matcher;
            }

            @Override
            public Object invoke(GeneratorHandler handler, Invoke invoke) throws Throwable {
                return function.apply(invoke);
            }
        };
    }

    public List<GeneratedFunction> getFunctions() {
        return this.functions;
    }

    public Generator getGenerator() {
        return this.generator;
    }

    void setObject(Object object) {
        this.object = object;
    }
}

