package in.kyle.api.generate.processors.create;

import java.lang.reflect.Field;

import in.kyle.api.generate.api.GeneratorHandler;
import in.kyle.api.generate.api.Generated;
import in.kyle.api.generate.processors.Processor;

public class CreateProcessor implements Processor<Field> {
    @SuppressWarnings("unchecked")
    @Override
    public <I extends Generated> void process(Class<I> clazz,
                                              I instance,
                                              Field field,
                                              GeneratorHandler handler) throws Exception {
        field.setAccessible(true);
        field.set(instance,
                  handler.getGenerator().create((Class<? extends Generated>) field.getType()));
    }
}
