package in.kyle.api.generate.helper;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public final class ReflectHelper {
    
    private ReflectHelper() {
    }
    
    public static Field getAccessibleField(Class<?> clazz, String name) {
        Field field = getField(clazz, name);
        if (field != null) {
            field.setAccessible(true);
        }
        return field;
    }
    
    public static Field getField(Class<?> clazz, String name) {
        return getFields(clazz).stream()
                               .filter(field -> field.getName().equals(name))
                               .findFirst()
                               .orElse(null);
    }
    
    public static Collection<Field> getFields(Class<?> clazz) {
        Set<Field> fields = new HashSet<>();
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        
        if (!clazz.equals(Object.class)) {
            fields.addAll(getFields(clazz.getSuperclass()));
        }
        
        return fields;
    }
    
    public static Collection<Method> getMethods(Class<?> clazz) {
        Set<Method> methods = new HashSet<>();
        methods.addAll(Arrays.asList(clazz.getDeclaredMethods()));
        
        if (!clazz.equals(Object.class)) {
            methods.addAll(getMethods(clazz.getSuperclass()));
        }
        
        return methods;
    }
    
    public static Collection<Member> getMembers(Class<?> src) {
        Set<Member> members = new HashSet<>();
        members.addAll(getFields(src));
        members.addAll(getMethods(src));
        return members;
    }
    
    public static Collection<AnnotatedElement> getAnnotatedElements(Class<?> src) {
        return getMembers(src).stream().map(m -> (AnnotatedElement) m).collect(Collectors.toSet());
    }
}
