/*
 * Decompiled with CFR 0.152.
 */
package in.kyle.api.bukkit.util;

import java.beans.ConstructorProperties;
import java.util.ArrayList;

public class BoundedArrayList<T>
extends ArrayList<T> {
    private final int bound;

    @Override
    public boolean add(T t) {
        if (this.size() + 1 < this.bound) {
            return super.add(t);
        }
        throw new IndexOutOfBoundsException("List is full");
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BoundedArrayList)) {
            return false;
        }
        BoundedArrayList other = (BoundedArrayList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.getBound() == other.getBound();
    }

    protected boolean canEqual(Object other) {
        return other instanceof BoundedArrayList;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        result = result * 59 + this.getBound();
        return result;
    }

    @ConstructorProperties(value={"bound"})
    public BoundedArrayList(int bound) {
        this.bound = bound;
    }

    public int getBound() {
        return this.bound;
    }

    @Override
    public String toString() {
        return "BoundedArrayList(bound=" + this.getBound() + ")";
    }
}

