/*
 * Decompiled with CFR 0.152.
 */
package in.kyle.api.bukkit.plugin;

import in.kyle.api.bukkit.TestServer;
import in.kyle.api.generate.api.Generated;
import in.kyle.api.generate.processors.increment.Increment;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.util.logging.Logger;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public abstract class TestPlugin
implements Plugin,
Generated {
    private static final Logger log = Logger.getLogger(TestPlugin.class.getName());
    private final TestServer server;
    private FileConfiguration config = new YamlConfiguration();
    @Increment
    private String name;
    private boolean enabled = true;

    public InputStream getResource(String filename) {
        return this.getClass().getResourceAsStream(filename);
    }

    public Logger getLogger() {
        return Logger.getLogger(this.name);
    }

    @ConstructorProperties(value={"server"})
    public TestPlugin(TestServer server) {
        this.server = server;
    }

    public TestServer getServer() {
        return this.server;
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setConfig(FileConfiguration config) {
        this.config = config;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestPlugin)) {
            return false;
        }
        TestPlugin other = (TestPlugin)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TestServer this$server = this.getServer();
        TestServer other$server = other.getServer();
        if (this$server == null ? other$server != null : !((Object)this$server).equals(other$server)) {
            return false;
        }
        FileConfiguration this$config = this.getConfig();
        FileConfiguration other$config = other.getConfig();
        if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        return this.isEnabled() == other.isEnabled();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TestPlugin;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TestServer $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : ((Object)$server).hashCode());
        FileConfiguration $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "TestPlugin(server=" + this.getServer() + ", config=" + this.getConfig() + ", name=" + this.getName() + ", enabled=" + this.isEnabled() + ")";
    }
}

