/*
 * Decompiled with CFR 0.152.
 */
package in.kyle.api.bukkit.entity;

import in.kyle.api.bukkit.TestOfflinePlayer;
import in.kyle.api.bukkit.TestServer;
import in.kyle.api.bukkit.entity.TestLivingEntity;
import in.kyle.api.generate.api.Generated;
import in.kyle.api.generate.processors.copy.Copy;
import in.kyle.api.generate.processors.create.Create;
import in.kyle.api.generate.processors.setup.Setup;
import io.reactivex.subjects.PublishSubject;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftPlayer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public abstract class TestPlayer
extends TestLivingEntity
implements Player {
    private final PublishSubject<String> kick = PublishSubject.create();
    private boolean op;
    @Create
    private TestOfflinePlayer offlinePlayer;

    public TestPlayer(TestServer server) {
        super(server);
    }

    @Setup
    public void setup() {
        this.offlinePlayer.setName(super.getName());
        this.offlinePlayer.setOp(this.offlinePlayer.isOp());
    }

    public void sendRawMessage(String message) {
        this.sendMessage(message);
    }

    public void chat(String msg) {
        this.sendRawMessage(msg);
    }

    @Override
    public EntityType getType() {
        return EntityType.PLAYER;
    }

    @Copy(value=CraftPlayer.class)
    public abstract boolean performCommand(String var1);

    @Copy(value=CraftPlayer.class)
    public abstract void resetPlayerTime();

    @Copy(value=CraftPlayer.class)
    public abstract boolean isBanned();

    @Copy(value=CraftPlayer.class)
    public abstract void setWhitelisted(boolean var1);

    @Copy(value=CraftPlayer.class)
    public abstract boolean isWhitelisted();

    @Copy(value=CraftPlayer.class)
    public abstract Map<String, Object> serialize();

    @Copy(value=CraftPlayer.class)
    public abstract void setMetadata(String var1, MetadataValue var2);

    @Copy(value=CraftPlayer.class)
    public abstract List<MetadataValue> getMetadata(String var1);

    @Copy(value=CraftPlayer.class)
    public abstract boolean hasMetadata(String var1);

    @Copy(value=CraftPlayer.class)
    public abstract void removeMetadata(String var1, Plugin var2);

    @Copy(value=CraftPlayer.class)
    public abstract boolean isOnline();

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestPlayer)) {
            return false;
        }
        TestPlayer other = (TestPlayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PublishSubject<String> this$kick = this.getKick();
        PublishSubject<String> other$kick = other.getKick();
        if (this$kick == null ? other$kick != null : !this$kick.equals(other$kick)) {
            return false;
        }
        if (this.isOp() != other.isOp()) {
            return false;
        }
        TestOfflinePlayer this$offlinePlayer = this.getOfflinePlayer();
        TestOfflinePlayer other$offlinePlayer = other.getOfflinePlayer();
        return !(this$offlinePlayer == null ? other$offlinePlayer != null : !((Object)this$offlinePlayer).equals(other$offlinePlayer));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TestPlayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        PublishSubject<String> $kick = this.getKick();
        result = result * 59 + ($kick == null ? 43 : $kick.hashCode());
        result = result * 59 + (this.isOp() ? 79 : 97);
        TestOfflinePlayer $offlinePlayer = this.getOfflinePlayer();
        result = result * 59 + ($offlinePlayer == null ? 43 : ((Object)$offlinePlayer).hashCode());
        return result;
    }

    public PublishSubject<String> getKick() {
        return this.kick;
    }

    @Override
    public boolean isOp() {
        return this.op;
    }

    public TestOfflinePlayer getOfflinePlayer() {
        return this.offlinePlayer;
    }

    @Override
    public void setOp(boolean op) {
        this.op = op;
    }

    public void setOfflinePlayer(TestOfflinePlayer offlinePlayer) {
        this.offlinePlayer = offlinePlayer;
    }

    @Override
    public String toString() {
        return "TestPlayer(kick=" + this.getKick() + ", op=" + this.isOp() + ", offlinePlayer=" + this.getOfflinePlayer() + ")";
    }

    public Player getPlayer() {
        return this.getOfflinePlayer().getPlayer();
    }

    @Override
    public TestServer getServer() {
        return this.getOfflinePlayer().getServer();
    }

    @Override
    public UUID getUniqueId() {
        return this.getOfflinePlayer().getUniqueId();
    }

    @Override
    public String getName() {
        return this.getOfflinePlayer().getName();
    }

    @Override
    public void setUniqueId(UUID uniqueId) {
        this.getOfflinePlayer().setUniqueId(uniqueId);
    }

    @Override
    public void setName(String name) {
        this.getOfflinePlayer().setName(name);
    }

    public long getFirstPlayed() {
        return this.getOfflinePlayer().getFirstPlayed();
    }

    public long getLastPlayed() {
        return this.getOfflinePlayer().getLastPlayed();
    }

    public boolean hasPlayedBefore() {
        return this.getOfflinePlayer().hasPlayedBefore();
    }

    public Location getBedSpawnLocation() {
        return this.getOfflinePlayer().getBedSpawnLocation();
    }

    private static interface Exclude
    extends Generated {
        public boolean isBanned();

        public void setWhitelisted(boolean var1);

        public boolean isWhitelisted();

        public Map<String, Object> serialize();

        public boolean isOnline();

        public boolean isOp();

        public boolean setOp(boolean var1);
    }
}

