/*
 * Decompiled with CFR 0.152.
 */
package in.kyle.api.bukkit.entity;

import in.kyle.api.bukkit.TestServer;
import in.kyle.api.bukkit.entity.TestHumanEntity;
import in.kyle.api.generate.processors.collection.set.ImplementSet;
import in.kyle.api.generate.processors.copy.Copy;
import in.kyle.api.generate.processors.map.ImplementMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftLivingEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionEffect;

public abstract class TestLivingEntity
extends TestHumanEntity
implements LivingEntity {
    @ImplementSet(type=PotionEffect.class)
    private final Set<PotionEffect> potionEffects = new HashSet<PotionEffect>();
    @ImplementMap(key=Attribute.class, value=AttributeInstance.class)
    private final Map<Attribute, AttributeInstance> attributes = new HashMap<Attribute, AttributeInstance>();

    public TestLivingEntity(TestServer server) {
        super(server);
    }

    public double getEyeHeight(boolean ignoreSneaking) {
        return this.getEyeHeight();
    }

    private List<Block> getLineOfSight(HashSet<Byte> transparent, int maxDistance) {
        return this.getLineOfSight(transparent, maxDistance, 0);
    }

    public List<Block> getLineOfSight(Set<Material> transparent, int maxDistance) {
        return this.getLineOfSight(transparent, maxDistance, 0);
    }

    @Copy(value=CraftLivingEntity.class)
    public abstract List<Block> getLineOfSight(Set<Material> var1, int var2, int var3);

    public Block getTargetBlock(HashSet<Byte> transparent, int maxDistance) {
        List<Block> blocks = this.getLineOfSight(transparent, maxDistance, 1);
        return blocks.get(0);
    }

    public Block getTargetBlock(Set<Material> transparent, int maxDistance) {
        List<Block> blocks = this.getLineOfSight(transparent, maxDistance, 1);
        return blocks.get(0);
    }

    public List<Block> getLastTwoTargetBlocks(HashSet<Byte> transparent, int maxDistance) {
        return this.getLineOfSight(transparent, maxDistance, 2);
    }

    public List<Block> getLastTwoTargetBlocks(Set<Material> transparent, int maxDistance) {
        return this.getLineOfSight(transparent, maxDistance, 2);
    }

    @Copy(value=CraftLivingEntity.class)
    public abstract Location getEyeLocation();

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestLivingEntity)) {
            return false;
        }
        TestLivingEntity other = (TestLivingEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Set<PotionEffect> this$potionEffects = this.getPotionEffects();
        Set<PotionEffect> other$potionEffects = other.getPotionEffects();
        if (this$potionEffects == null ? other$potionEffects != null : !((Object)this$potionEffects).equals(other$potionEffects)) {
            return false;
        }
        Map<Attribute, AttributeInstance> this$attributes = this.getAttributes();
        Map<Attribute, AttributeInstance> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TestLivingEntity;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Set<PotionEffect> $potionEffects = this.getPotionEffects();
        result = result * 59 + ($potionEffects == null ? 43 : ((Object)$potionEffects).hashCode());
        Map<Attribute, AttributeInstance> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    public Set<PotionEffect> getPotionEffects() {
        return this.potionEffects;
    }

    public Map<Attribute, AttributeInstance> getAttributes() {
        return this.attributes;
    }

    @Override
    public String toString() {
        return "TestLivingEntity(potionEffects=" + this.getPotionEffects() + ", attributes=" + this.getAttributes() + ")";
    }
}

