/*
 * Decompiled with CFR 0.152.
 */
package in.kyle.api.bukkit;

import in.kyle.api.bukkit.TestPermissible;
import in.kyle.api.bukkit.TestServer;
import in.kyle.api.generate.api.Generated;
import io.reactivex.subjects.PublishSubject;
import org.bukkit.command.ConsoleCommandSender;

public abstract class TestConsoleCommandSender
extends TestPermissible
implements ConsoleCommandSender,
Generated {
    private final PublishSubject<String> messages = PublishSubject.create();
    private final TestServer server;
    private final String name = "Console";

    public TestConsoleCommandSender(TestServer server) {
        this.server = server;
        this.setOp(true);
    }

    public void sendMessage(String message) {
        this.sendRawMessage(message);
    }

    public void sendMessage(String[] messages) {
        for (String message : messages) {
            this.sendMessage(message);
        }
    }

    public void sendRawMessage(String message) {
        this.messages.onNext((Object)message);
        System.out.println("Console < " + message);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestConsoleCommandSender)) {
            return false;
        }
        TestConsoleCommandSender other = (TestConsoleCommandSender)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PublishSubject<String> this$messages = this.getMessages();
        PublishSubject<String> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !this$messages.equals(other$messages)) {
            return false;
        }
        TestServer this$server = this.getServer();
        TestServer other$server = other.getServer();
        if (this$server == null ? other$server != null : !((Object)this$server).equals(other$server)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TestConsoleCommandSender;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        PublishSubject<String> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : $messages.hashCode());
        TestServer $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : ((Object)$server).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public PublishSubject<String> getMessages() {
        return this.messages;
    }

    public TestServer getServer() {
        return this.server;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return "TestConsoleCommandSender(messages=" + this.getMessages() + ", server=" + this.getServer() + ", name=" + this.getName() + ")";
    }
}

