/*
 * Decompiled with CFR 0.152.
 */
package in.kyle.api.bukkit;

import in.kyle.api.bukkit.block.TestBlock;
import in.kyle.api.generate.api.Generated;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public abstract class TestChunk
implements Chunk,
Generated {
    private final Map<Vector, Block> blocks = new HashMap<Vector, Block>();
    private final Set<Entity> entities = new HashSet<Entity>();
    private int x;
    private int z;
    private World world;

    public Block getBlock(int x, int y, int z) {
        Vector key = new Vector(x, y, z);
        if (this.blocks.containsKey(key)) {
            return this.blocks.get(key);
        }
        TestBlock block = (TestBlock)this.getInternalGenerator().create(TestBlock.class);
        block.setX(x);
        block.setY(y);
        block.setZ(z);
        block.setChunk(this);
        return block;
    }

    public Entity[] getEntities() {
        return this.entities.toArray(new Entity[this.entities.size()]);
    }

    public boolean isLoaded() {
        return true;
    }

    public Map<Vector, Block> getBlocks() {
        return this.blocks;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public World getWorld() {
        return this.world;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestChunk)) {
            return false;
        }
        TestChunk other = (TestChunk)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<Vector, Block> this$blocks = this.getBlocks();
        Map<Vector, Block> other$blocks = other.getBlocks();
        if (this$blocks == null ? other$blocks != null : !((Object)this$blocks).equals(other$blocks)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getEntities(), other.getEntities())) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        if (this.getZ() != other.getZ()) {
            return false;
        }
        World this$world = this.getWorld();
        World other$world = other.getWorld();
        return !(this$world == null ? other$world != null : !this$world.equals(other$world));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TestChunk;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<Vector, Block> $blocks = this.getBlocks();
        result = result * 59 + ($blocks == null ? 43 : ((Object)$blocks).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getEntities());
        result = result * 59 + this.getX();
        result = result * 59 + this.getZ();
        World $world = this.getWorld();
        result = result * 59 + ($world == null ? 43 : $world.hashCode());
        return result;
    }

    public String toString() {
        return "TestChunk(blocks=" + this.getBlocks() + ", entities=" + Arrays.deepToString(this.getEntities()) + ", x=" + this.getX() + ", z=" + this.getZ() + ", world=" + this.getWorld() + ")";
    }
}

