package in.kyle.api.bukkit.entity;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftLivingEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionEffect;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import in.kyle.api.bukkit.TestServer;
import in.kyle.api.generate.processors.copy.Copy;
import in.kyle.api.generate.processors.map.ImplementMap;
import in.kyle.api.generate.processors.collection.set.ImplementSet;
import lombok.Data;
import lombok.EqualsAndHashCode;

@EqualsAndHashCode(callSuper = true)
@SuppressWarnings("unchecked")
@Data
public abstract class TestLivingEntity extends TestHumanEntity implements LivingEntity {
    
    @ImplementSet(type = PotionEffect.class)
    private final Set<PotionEffect> potionEffects = new HashSet<>();
    
    @ImplementMap(key = Attribute.class, value = AttributeInstance.class)
    private final Map<Attribute, AttributeInstance> attributes = new HashMap<>();
    
    public TestLivingEntity(TestServer server) {
        super(server);
    }
    
    @Override
    public double getEyeHeight(boolean ignoreSneaking) {
        return getEyeHeight();
    }
    
    private List<Block> getLineOfSight(HashSet<Byte> transparent, int maxDistance) {
        return this.getLineOfSight((HashSet)transparent, maxDistance, 0);
    }
    
    @Override
    public List<Block> getLineOfSight(Set<Material> transparent, int maxDistance) {
        return this.getLineOfSight((Set)transparent, maxDistance, 0);
    }
    
    @Copy(CraftLivingEntity.class)
    public abstract List<Block> getLineOfSight(Set<Material> transparent,
                                                int maxDistance,
                                                int maxLength);
    
    @Override
    public Block getTargetBlock(HashSet<Byte> transparent, int maxDistance) {
        List<Block> blocks = this.getLineOfSight((HashSet)transparent, maxDistance, 1);
        return blocks.get(0);
    }
    
    @Override
    public Block getTargetBlock(Set<Material> transparent, int maxDistance) {
        List<Block> blocks = this.getLineOfSight((Set)transparent, maxDistance, 1);
        return blocks.get(0);
    }
    
    public List<Block> getLastTwoTargetBlocks(HashSet<Byte> transparent, int maxDistance) {
        return getLineOfSight((HashSet) transparent, maxDistance, 2);
    }
    
    public List<Block> getLastTwoTargetBlocks(Set<Material> transparent, int maxDistance) {
        return getLineOfSight((Set) transparent, maxDistance, 2);
    }
    
    @Override
    @Copy(CraftLivingEntity.class)
    public abstract Location getEyeLocation();
}
