package in.kyle.api.bukkit.entity;

import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

import in.kyle.api.bukkit.TestServer;
import lombok.Data;

@Data
public abstract class TestItem extends TestEntity implements Item {
    
    private ItemStack itemStack;
    private int pickupDelay = 0;
    private Vector velocity = new Vector(0, 0, 0);
    private boolean alive = true;
    
    public TestItem(TestServer server) {
        super(server);
        setType(EntityType.DROPPED_ITEM);
    }
}
