package in.kyle.api.bukkit.entity;

import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.util.Vector;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

import in.kyle.api.bukkit.TestCommandSender;
import in.kyle.api.bukkit.TestServer;
import in.kyle.api.generate.api.Generated;
import in.kyle.api.generate.processors.copy.Copy;
import in.kyle.api.generate.processors.increment.Increment;
import in.kyle.api.generate.processors.collection.list.ImplementList;
import in.kyle.api.generate.processors.collection.set.ImplementSet;
import lombok.Data;
import lombok.EqualsAndHashCode;

@EqualsAndHashCode(callSuper = true)
@Data
public abstract class TestEntity extends TestCommandSender implements Entity, Generated {
    
    private final Server server;
    
    @ImplementList(type = Entity.class)
    private final List<Entity> passengers = new ArrayList<>();
    
    @ImplementSet(type = String.class)
    private final Set<String> scoreboardTags = new HashSet<>();
    
    private UUID uniqueId = UUID.randomUUID();
    
    @Increment
    private int entityId;
    private Vector velocity = new Vector(0, 0, 0);
    private Location location;
    private EntityType type;
    
    protected TestEntity(TestServer server) {
        this.server = server;
        location = new Location(server.getWorld(), 0, 0, 0);
    }
    
    @Override
    @Copy(CraftEntity.class)
    public abstract Location getLocation(Location loc);
    
    @Override
    public boolean teleport(Location location) {
        this.location = location;
        return true;
    }
    
    @Override
    public boolean teleport(Entity destination, PlayerTeleportEvent.TeleportCause cause) {
        return teleport(destination.getLocation());
    }
    
    @Override
    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        return teleport(location);
    }
    
    @Override
    public boolean teleport(Entity destination) {
        return teleport(destination.getLocation());
    }
}
