package in.kyle.api.bukkit.entity;

import org.bukkit.entity.Arrow;
import org.bukkit.entity.EntityType;
import org.bukkit.projectiles.ProjectileSource;

import in.kyle.api.bukkit.TestServer;
import lombok.Data;
import lombok.EqualsAndHashCode;

@EqualsAndHashCode(callSuper = true)
@Data
public abstract class TestArrow extends TestEntity implements Arrow {
    
    private PickupStatus pickupStatus;
    private ProjectileSource shooter;
    
    private int knockbackStrength;
    
    private boolean critical;
    private boolean bounce;
    
    public TestArrow(TestServer server) {
        super(server);
        setType(EntityType.ARROW);
    }
    
    @Override
    public boolean doesBounce() {
        return bounce;
    }
    
//    @Override
//    public void shoot(double x, double y, double z, float speed, float spread) {
//        Random random = new Random();
//        float f2 = MathHelper.sqrt(x * x + y * y + z * z);
//        x /= (double) f2;
//        y /= (double) f2;
//        z /= (double) f2;
//        x += random.nextGaussian() * 0.007499999832361937D * (double) spread;
//        y += random.nextGaussian() * 0.007499999832361937D * (double) spread;
//        z += random.nextGaussian() * 0.007499999832361937D * (double) spread;
//        x *= (double) speed;
//        y *= (double) speed;
//        z *= (double) speed;
//        double motX = x;
//        double motY = y;
//        double motZ = z;
//        float f3 = MathHelper.sqrt(x * x + z * z);
//        float yaw = (float) (MathHelper.c(x, z) * 57.2957763671875D);
//        float pitch = (float) (MathHelper.c(y, (double) f3) * 57.2957763671875D);
//        Vector velocity = getVelocity();
//        velocity.setX(motX);
//        velocity.setY(motY);
//        velocity.setZ(motZ);
//        
//        getLocation().setPitch(pitch);
//        getLocation().setYaw(yaw);
//    }
}
