package in.kyle.api.bukkit.entity;

import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

import in.kyle.api.generate.api.Generated;
import in.kyle.api.generate.api.Generator;

public final class EntityFactory {
    
    private static final Map<Class<? extends Entity>, Function<Generator, Entity>> TYPE_MAP =
            new HashMap<>();
    
    static {
        add(Arrow.class, g -> g.create(TestArrow.class));
    }
    
    
    private EntityFactory() {
    }
    
    public static <T extends Entity> void add(Class<T> clazz, Function<Generator, T> function) {
        TYPE_MAP.put(clazz, (Function<Generator, Entity>) function);
    }
    
    public static <T extends Entity> T make(Generated generated, Class<T> clazz) {
        Function<Generator, Entity> function = TYPE_MAP.get(clazz);
        if (function == null) {
            throw new RuntimeException("Factory not defined for type " + clazz.getName());
        }
        return (T) function.apply(generated.getInternalGenerator());
    }
}
