package in.kyle.api.bukkit.block;

import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftBlock;

import in.kyle.api.bukkit.TestWorld;
import in.kyle.api.generate.api.Generated;
import in.kyle.api.generate.processors.copy.Copy;
import lombok.Data;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
@Data
public abstract class TestBlock implements Block, Generated {
    
    private int x;
    private int y;
    private int z;
    private Chunk chunk;
    
    private byte data = 0;
    private Material type = Material.AIR;
    
    public Block getRelative(int x, int y, int z) {
        return chunk.getWorld().getBlockAt(this.x + x, this.y + y, this.z + z);
    }
    
    public Block getRelative(BlockFace blockFace) {
        return getRelative(blockFace, 1);
    }
    
    public Block getRelative(BlockFace blockFace, int i) {
        return getRelative(blockFace.getModX() * i,
                           blockFace.getModY() * i,
                           blockFace.getModZ() * i);
    }
    
    public int getTypeId() {
        return getType().getId();
    }
    
    public TestWorld getWorld() {
        return (TestWorld) chunk.getWorld();
    }
    
    public Location getLocation() {
        return new Location(chunk.getWorld(), x, y, z);
    }
    
    public Location getLocation(Location location) {
        location.setX(x);
        location.setY(y);
        location.setZ(z);
        return location;
    }
    
    public void setData(byte b, boolean b1) {
        setData(b);
    }
    
    public void setType(Material material, boolean b) {
        setType(material);
    }
    
    public boolean setTypeId(int i) {
        Material material = Material.getMaterial(i);
        boolean b = material != type;
        setType(material);
        return b;
    }
    
    public boolean setTypeId(int i, boolean b) {
        setTypeId(i);
        return true;
    }
    
    public boolean setTypeIdAndData(int i, byte b, boolean b1) {
        setData(b);
        return setTypeId(i);
    }
    
    @Copy(CraftBlock.class)
    public abstract BlockFace getFace(Block block);
    
    public Biome getBiome() {
        return getWorld().getBiome(x, z);
    }
    
    public void setBiome(Biome biome) {
        getWorld().setBiome(x, z, biome);
    }
}
