package in.kyle.api.bukkit;

import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;

import java.util.Set;

import lombok.Data;

@Data
public abstract class TestPermissible implements Permissible { // idc
    
    protected final PermissibleBase perm = new PermissibleBase(this);
    
    private boolean op;
    
    @Override
    public boolean isPermissionSet(String name) {
        return perm.isPermissionSet(name);
    }
    
    @Override
    public boolean isPermissionSet(Permission perm) {
        return this.perm.isPermissionSet(perm);
    }
    
    @Override
    public boolean hasPermission(String name) {
        return perm.hasPermission(name);
    }
    
    @Override
    public boolean hasPermission(Permission perm) {
        return this.perm.hasPermission(perm);
    }
    
    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value) {
        return perm.addAttachment(plugin, name, value);
    }
    
    @Override
    public PermissionAttachment addAttachment(Plugin plugin) {
        return perm.addAttachment(plugin);
    }
    
    @Override
    public PermissionAttachment addAttachment(Plugin plugin,
                                              String name,
                                              boolean value,
                                              int ticks) {
        return perm.addAttachment(plugin, name, value, ticks);
    }
    
    @Override
    public PermissionAttachment addAttachment(Plugin plugin, int ticks) {
        return perm.addAttachment(plugin, ticks);
    }
    
    @Override
    public void removeAttachment(PermissionAttachment attachment) {
        perm.removeAttachment(attachment);
    }
    
    @Override
    public void recalculatePermissions() {
        perm.recalculatePermissions();
    }
    
    @Override
    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        return perm.getEffectivePermissions();
    }
}
