package in.kyle.api.bukkit;

import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_12_R1.CraftOfflinePlayer;
import org.bukkit.entity.Player;

import java.util.UUID;

import in.kyle.api.generate.api.Generated;
import in.kyle.api.generate.processors.copy.Copy;
import in.kyle.api.generate.processors.increment.Increment;
import lombok.Data;

@Data
public abstract class TestOfflinePlayer implements OfflinePlayer, Generated {
    
    private final TestServer server;
    
    private UUID uniqueId = UUID.randomUUID();
    
    @Increment
    private String name;
    
    protected TestOfflinePlayer(TestServer server) {
        this.server = server;
    }
    
    @Override
    @Copy(CraftOfflinePlayer.class)
    public abstract Player getPlayer();
}
