package in.kyle.api.bukkit;

import org.bukkit.command.ConsoleCommandSender;

import in.kyle.api.generate.api.Generated;
import io.reactivex.subjects.PublishSubject;
import lombok.Data;
import lombok.EqualsAndHashCode;

@EqualsAndHashCode(callSuper = true)
@Data
public abstract class TestConsoleCommandSender extends TestPermissible
        implements ConsoleCommandSender, Generated {
    
    private final PublishSubject<String> messages = PublishSubject.create();
    
    private final TestServer server;
    
    private final String name = "Console";
    
    public TestConsoleCommandSender(TestServer server) {
        this.server = server;
        setOp(true);
    }
    
    @Override
    public void sendMessage(String message) {
        sendRawMessage(message);
    }
    
    @Override
    public void sendMessage(String[] messages) {
        for (String message : messages) {
            sendMessage(message);
        }
    }
    
    @Override
    public void sendRawMessage(String message) {
        messages.onNext(message);
        System.out.println("Console < " + message);
    }
}
