package in.kyle.api.bukkit;

import org.bukkit.plugin.Plugin;

import sun.misc.Unsafe;

import java.lang.reflect.Field;

import in.kyle.api.utils.Try;
import in.kyle.api.verify.Verify;

public final class Plugins {
    
    private static final Unsafe UNSAFE = Try.to(() -> {
        Field theUnsafeField = Unsafe.class.getDeclaredField("theUnsafe");
        theUnsafeField.setAccessible(true);
        return (Unsafe) theUnsafeField.get(null);
    });
    
    private Plugins() {
    }
    
    public static <T extends Plugin> T create(Class<T> clazz) {
        Verify.that(() -> clazz.newInstance()).throwsException(IllegalStateException.class);
        return (T) Try.to(() -> UNSAFE.allocateInstance(clazz));
    }
}
