/*
 * Decompiled with CFR 0.152.
 */
package com.github.kxfeng.securepreferences;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.provider.Settings;
import android.security.keystore.KeyGenParameterSpec;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.github.kxfeng.securepreferences.CiphertextIv;
import com.github.kxfeng.securepreferences.CryptoUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class AppKeyStore {
    private static Context sApplicationContext;
    private static String sSystemKeyStoreMasterKeyAlias;
    private static String sAppKeyStorePreferencesName;
    private static final String ANDROID_KEY_STORE = "AndroidKeyStore";
    private static final String KEY_COMPATIBLE = "compatible";
    private static final int MASTER_KEY_BIT_SIZE = 256;
    private static final String MASTER_KEY_ALGORITHM = "AES";
    private static final String MASTER_CIPHER_GCM_TRANSFORMATION = "AES/GCM/NoPadding";
    private static final int MASTER_CIPHER_GCM_TAG_BIT_LENGTH = 128;
    private static final int MASTER_CIPHER_GCM_IV_BIT_SIZE = 96;
    private static final Charset CHARSET_UTF8;
    private static final String TAG = "AppKeyStore";
    private static boolean sDebugLog;

    public static void init(@NonNull Context context) {
        AppKeyStore.init(context, "app_key_store_master_key", "app_key_store");
    }

    public static void init(@NonNull Context context, @NonNull String systemKeyStoreMasterKeyAlias, @NonNull String appKeyStorePreferenceName) {
        sApplicationContext = context.getApplicationContext();
        sSystemKeyStoreMasterKeyAlias = systemKeyStoreMasterKeyAlias;
        sAppKeyStorePreferencesName = appKeyStorePreferenceName;
    }

    public static void setDebugLog(boolean debugLog) {
        sDebugLog = debugLog;
    }

    public static SecretKey getOrCreateSecretKey(@NonNull String keyAlias, @NonNull String algorithm, int keySizeInBits) {
        String encryptKeyAlias;
        AppKeyStore.checkInit();
        if (keySizeInBits % 8 != 0) {
            throw new IllegalArgumentException("key bit size must be multiple of 8");
        }
        SecretKey masterKey = AppKeyStore.getMasterKey();
        SharedPreferences preferences = AppKeyStore.getKeyStorePreferences();
        try {
            encryptKeyAlias = AppKeyStore.encryptKeyAlias(masterKey, keyAlias);
        }
        catch (GeneralSecurityException ex) {
            throw new KeyStoreUnavailableException("Failed to encrypt key alias, so unable to recover secret key from storage", ex);
        }
        String keyData = preferences.getString(encryptKeyAlias, null);
        if (!TextUtils.isEmpty((CharSequence)keyData)) {
            try {
                return AppKeyStore.decryptSecretKey(masterKey, keyData, algorithm);
            }
            catch (GeneralSecurityException ex) {
                Log.w((String)TAG, (String)("decrypt key fail, create new key instead: " + keyAlias));
            }
        }
        byte[] randomBytes = CryptoUtil.randomBytes(keySizeInBits / 8);
        SecretKeySpec secretKey = new SecretKeySpec(randomBytes, algorithm);
        try {
            String encrypted = AppKeyStore.encryptSecretKey(masterKey, secretKey);
            preferences.edit().putString(encryptKeyAlias, encrypted).apply();
            return secretKey;
        }
        catch (GeneralSecurityException ex) {
            throw new KeyStoreUnavailableException("Failed to encrypt the created secret key, so unable to persist it to storage", ex);
        }
    }

    private static SecretKey getMasterKey() {
        SharedPreferences preferences = AppKeyStore.getKeyStorePreferences();
        if (preferences.getBoolean(KEY_COMPATIBLE, false)) {
            if (sDebugLog) {
                Log.d((String)TAG, (String)"get MasterKey compatible flag");
            }
            return AppKeyStore.getMasterKeyCompat();
        }
        if (Build.VERSION.SDK_INT < 23) {
            if (sDebugLog) {
                Log.d((String)TAG, (String)"get MasterKey below Marshmallow");
            }
            preferences.edit().putBoolean(KEY_COMPATIBLE, true).apply();
            return AppKeyStore.getMasterKeyCompat();
        }
        try {
            return AppKeyStore.getMasterKeyByKeyStore(sSystemKeyStoreMasterKeyAlias);
        }
        catch (IOException | GeneralSecurityException ex) {
            Log.w((String)TAG, (String)("get MasterKey in keystore error, fallback to compat: " + ex.toString()));
            preferences.edit().putBoolean(KEY_COMPATIBLE, true).apply();
            return AppKeyStore.getMasterKeyCompat();
        }
    }

    @TargetApi(value=23)
    private static SecretKey getMasterKeyByKeyStore(String masterKeyAlias) throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStore.getInstance(ANDROID_KEY_STORE);
        keyStore.load(null);
        if (keyStore.containsAlias(masterKeyAlias)) {
            KeyStore.Entry entry = keyStore.getEntry(masterKeyAlias, null);
            if (entry instanceof KeyStore.SecretKeyEntry) {
                if (sDebugLog) {
                    Log.d((String)TAG, (String)"master key already exist");
                }
                return ((KeyStore.SecretKeyEntry)entry).getSecretKey();
            }
            keyStore.deleteEntry(masterKeyAlias);
            Log.w((String)TAG, (String)"master key type not match, delete it to recreate");
        }
        if (sDebugLog) {
            Log.d((String)TAG, (String)"create master key in KeyStore");
        }
        KeyGenerator keyGenerator = KeyGenerator.getInstance(MASTER_KEY_ALGORITHM, ANDROID_KEY_STORE);
        KeyGenParameterSpec spec = new KeyGenParameterSpec.Builder(masterKeyAlias, 3).setBlockModes(new String[]{"GCM"}).setEncryptionPaddings(new String[]{"NoPadding"}).setKeySize(256).setRandomizedEncryptionRequired(false).build();
        keyGenerator.init((AlgorithmParameterSpec)spec);
        return keyGenerator.generateKey();
    }

    private static SecretKey getMasterKeyCompat() {
        byte[] ids = Settings.Secure.getString((ContentResolver)sApplicationContext.getContentResolver(), (String)"android_id").getBytes(CHARSET_UTF8);
        byte[] key = Arrays.copyOf(ids, 32);
        return new SecretKeySpec(key, MASTER_KEY_ALGORITHM);
    }

    private static String encryptSecretKey(SecretKey masterKey, SecretKey key) throws GeneralSecurityException {
        byte[] iv = CryptoUtil.randomBytes(12);
        byte[] encrypted = AppKeyStore.encrypt(masterKey, key.getEncoded(), iv);
        return new CiphertextIv(encrypted, iv).toString();
    }

    private static SecretKey decryptSecretKey(SecretKey masterKey, String encryptedText, @NonNull String algorithm) throws GeneralSecurityException {
        CiphertextIv ciphertextIv = new CiphertextIv(encryptedText);
        byte[] decrypted = AppKeyStore.decrypt(masterKey, ciphertextIv.ciphertext, ciphertextIv.iv);
        return new SecretKeySpec(decrypted, algorithm);
    }

    private static String encryptKeyAlias(SecretKey masterKey, @NonNull String keyAlias) throws GeneralSecurityException {
        byte[] encrypted = AppKeyStore.encrypt(masterKey, keyAlias.getBytes(CHARSET_UTF8), AppKeyStore.getConstantKeyAliasIv());
        return Base64.encodeToString((byte[])encrypted, (int)2);
    }

    private static String decryptKeyAlias(SecretKey masterKey, @NonNull String encryptedText) throws GeneralSecurityException {
        byte[] decoded;
        try {
            decoded = Base64.decode((byte[])encryptedText.getBytes(CHARSET_UTF8), (int)2);
        }
        catch (IllegalArgumentException ex) {
            throw new GeneralSecurityException("Base64 decode error", ex);
        }
        byte[] decrypted = AppKeyStore.decrypt(masterKey, decoded, AppKeyStore.getConstantKeyAliasIv());
        return new String(decrypted, CHARSET_UTF8);
    }

    private static byte[] encrypt(SecretKey key, byte[] data, byte[] iv) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(MASTER_CIPHER_GCM_TRANSFORMATION);
        AlgorithmParameterSpec gcmParameterSpec = CryptoUtil.getGcmParameterSpec(iv, 128);
        cipher.init(1, (Key)key, gcmParameterSpec);
        return cipher.doFinal(data);
    }

    private static byte[] decrypt(SecretKey key, byte[] data, byte[] iv) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(MASTER_CIPHER_GCM_TRANSFORMATION);
        AlgorithmParameterSpec gcmParameterSpec = CryptoUtil.getGcmParameterSpec(iv, 128);
        cipher.init(2, (Key)key, gcmParameterSpec);
        return cipher.doFinal(data);
    }

    private static void checkInit() {
        if (sApplicationContext == null) {
            throw new IllegalStateException("Must call AppKeyStore.init() before any operation");
        }
    }

    private static byte[] getConstantKeyAliasIv() {
        byte[] ids = Settings.Secure.getString((ContentResolver)sApplicationContext.getContentResolver(), (String)"android_id").getBytes(CHARSET_UTF8);
        return Arrays.copyOf(ids, 12);
    }

    private static SharedPreferences getKeyStorePreferences() {
        return sApplicationContext.getApplicationContext().getSharedPreferences(sAppKeyStorePreferencesName, 0);
    }

    static {
        CHARSET_UTF8 = Charset.forName("UTF-8");
        sDebugLog = false;
    }

    public static class KeyStoreUnavailableException
    extends RuntimeException {
        KeyStoreUnavailableException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

